/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.ComponentEvent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class EventDataCache
implements Serializable {
    private ConcurrentHashMap<Class<? extends ComponentEvent<?>>, LinkedHashMap<String, Class<?>>> dataExpressions = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<? extends ComponentEvent<?>>, Constructor<?>> eventConstructors = new ConcurrentHashMap();

    public Optional<LinkedHashMap<String, Class<?>>> getDataExpressions(Class<? extends ComponentEvent<?>> eventType) {
        return Optional.ofNullable(this.dataExpressions.get(eventType));
    }

    public LinkedHashMap<String, Class<?>> setDataExpressions(Class<? extends ComponentEvent<?>> eventType, LinkedHashMap<String, Class<?>> expressions) {
        this.dataExpressions.put(eventType, expressions);
        return expressions;
    }

    public <T extends ComponentEvent<?>> Optional<Constructor<T>> getEventConstructor(Class<T> eventType) {
        return Optional.ofNullable(this.eventConstructors.get(eventType));
    }

    public <T extends ComponentEvent<?>> Constructor<T> setEventConstructor(Class<T> eventType, Constructor<T> constructor) {
        this.eventConstructors.put(eventType, constructor);
        return constructor;
    }

    void clear() {
        this.dataExpressions.clear();
        this.eventConstructors.clear();
    }
}

