/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.HasElement;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

public interface HasText
extends HasElement {
    default public void setText(String text) {
        this.getElement().setText(text);
    }

    default public String getText() {
        return this.getElement().getText();
    }

    default public void setWhiteSpace(WhiteSpace value) {
        this.getElement().getStyle().set("white-space", Objects.requireNonNull(value).toString());
    }

    default public WhiteSpace getWhiteSpace() {
        String value = this.getElement().getStyle().get("white-space");
        if (value == null) {
            return WhiteSpace.NORMAL;
        }
        return WhiteSpace.forString(value);
    }

    public static enum WhiteSpace {
        NORMAL,
        NOWRAP,
        PRE,
        PRE_WRAP,
        PRE_LINE,
        BREAK_SPACES,
        INHERIT,
        INITIAL;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        }

        public static WhiteSpace forString(String value) {
            return Stream.of(WhiteSpace.values()).filter(whiteSpace -> whiteSpace.toString().equals(value)).findFirst().orElse(null);
        }
    }
}

