/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouteTarget
implements Serializable {
    private Class<? extends Component> normal;
    private Class<? extends Component> parameter;
    private Class<? extends Component> optionalParameter;
    private Class<? extends Component> wildCardParameter;
    private Map<Class<?>, ThemeDefinition> routeThemes;

    public RouteTarget(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        this.addRoute(target);
    }

    public void addRoute(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (!HasUrlParameter.class.isAssignableFrom(target) && !this.isAnnotatedParameter(target)) {
            this.validateNormalTarget(target);
            this.normal = target;
        } else if (ParameterDeserializer.isAnnotatedParameter(target, OptionalParameter.class)) {
            this.validateOptionalParameter(target);
            this.optionalParameter = target;
        } else if (ParameterDeserializer.isAnnotatedParameter(target, WildcardParameter.class)) {
            this.validateWildcard(target);
            this.wildCardParameter = target;
        } else {
            this.validateParameter(target);
            this.parameter = target;
        }
    }

    private void validateParameter(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.parameter != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with parameter have the same route.", this.parameter.getName(), target.getName()));
        }
    }

    private void validateWildcard(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.wildCardParameter != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with wildcard parameter have the same route.", this.wildCardParameter.getName(), target.getName()));
        }
    }

    private void validateOptionalParameter(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.normal != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", this.normal.getName(), target.getName(), target.getName()));
        }
        if (this.optionalParameter != null) {
            String message = String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with parameter have the same route.", this.optionalParameter.getName(), target.getName());
            throw new InvalidRouteConfigurationException(message);
        }
    }

    private void validateNormalTarget(Class<? extends Component> target) throws InvalidRouteConfigurationException {
        if (this.normal != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets must have unique routes, found navigation targets '%s' and '%s' with the same route.", this.normal.getName(), target.getName()));
        }
        if (this.optionalParameter != null) {
            throw new InvalidRouteConfigurationException(String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", target.getName(), this.optionalParameter.getName(), this.optionalParameter.getName()));
        }
    }

    public Class<? extends Component> getTarget(List<String> segments) {
        if (segments.isEmpty() && this.normal != null) {
            return this.normal;
        }
        if (segments.size() == 1 && this.parameter != null) {
            return this.parameter;
        }
        if (segments.size() <= 1 && this.optionalParameter != null) {
            return this.optionalParameter;
        }
        if (this.wildCardParameter != null) {
            return this.wildCardParameter;
        }
        return null;
    }

    private boolean isAnnotatedParameter(Class<?> target) {
        return ParameterDeserializer.isAnnotatedParameter(target, OptionalParameter.class) || ParameterDeserializer.isAnnotatedParameter(target, WildcardParameter.class);
    }

    public void setThemeFor(Class<?> target, ThemeDefinition theme) {
        if (this.routeThemes == null) {
            this.routeThemes = new HashMap();
        }
        this.routeThemes.put(target, theme);
    }

    public ThemeDefinition getThemeFor(Class<?> target) {
        if (this.routeThemes == null) {
            return null;
        }
        return this.routeThemes.get(target);
    }
}

