/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public abstract class StateNodeNodeList
extends NodeList<StateNode> {
    protected StateNodeNodeList(StateNode node) {
        super(node);
    }

    @Override
    protected boolean isNodeValues() {
        return true;
    }

    @Override
    protected void add(int index, StateNode item) {
        assert (item != null);
        super.add(index, item);
        this.attachPotentialChild(item);
    }

    @Override
    protected void addAll(Collection<? extends StateNode> items) {
        super.addAll(items);
        items.forEach(this::attachPotentialChild);
    }

    @Override
    protected StateNode remove(int index) {
        StateNode removed = (StateNode)super.remove(index);
        this.detatchPotentialChild(removed);
        return removed;
    }

    @Override
    protected void clear() {
        int size = this.size();
        ArrayList children = null;
        if (size > 0) {
            children = new ArrayList(size);
            this.forEachChild(children::add);
        }
        super.clear();
        if (size > 0) {
            children.forEach(this::detatchPotentialChild);
        }
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
        this.iterator().forEachRemaining(action);
    }
}

