/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.MapRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.shared.util.UniqueSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public abstract class NodeMap
extends NodeFeature {
    private static final Serializable REMOVED_MARKER = new UniqueSerializable(){};
    private Map<String, Serializable> values;
    private boolean isPopulated;

    public NodeMap(StateNode node) {
        super(node);
        this.isPopulated = !node.isReportedFeature(this.getClass());
    }

    protected void put(String key, Serializable value) {
        this.put(key, value, true);
    }

    private void ensureValues() {
        if (this.values == null) {
            this.values = new HashMap<String, Serializable>();
        }
    }

    protected Serializable put(String key, Serializable value, boolean emitChange) {
        Serializable oldValue = this.get(key);
        if (this.contains(key) && Objects.equals(oldValue, value)) {
            return oldValue;
        }
        if (emitChange) {
            this.setChanged(key);
        } else {
            this.setUnChanged(key);
        }
        this.ensureValues();
        this.values.put(key, value);
        this.detatchPotentialChild(oldValue);
        this.attachPotentialChild(value);
        return oldValue;
    }

    protected Serializable get(String key) {
        this.setAccessed(key);
        if (this.values == null) {
            return null;
        }
        return this.values.get(key);
    }

    protected String getOrDefault(String key, String defaultValue) {
        if (this.contains(key)) {
            Serializable value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (String)((Object)value);
        }
        return defaultValue;
    }

    protected int getOrDefault(String key, int defaultValue) {
        if (this.contains(key)) {
            Serializable value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (Integer)value;
        }
        return defaultValue;
    }

    protected boolean getOrDefault(String key, boolean defaultValue) {
        if (this.contains(key)) {
            Serializable value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (Boolean)value;
        }
        return defaultValue;
    }

    protected Set<String> keySet() {
        if (this.values == null) {
            return Collections.emptySet();
        }
        return this.values.keySet();
    }

    protected boolean contains(String key) {
        this.setAccessed(key);
        if (this.values == null) {
            return false;
        }
        return this.values.containsKey(key);
    }

    protected Serializable remove(String key) {
        this.setChanged(key);
        if (this.values == null) {
            return null;
        }
        Serializable oldValue = this.values.remove(key);
        this.detatchPotentialChild(oldValue);
        if (this.values.isEmpty()) {
            this.values = null;
        }
        return oldValue;
    }

    protected void clear() {
        for (String key : new ArrayList<String>(this.keySet())) {
            this.remove(key);
        }
    }

    private void setUnChanged(String key) {
        assert (key != null);
        this.getChangeTracker().remove(key);
    }

    private void setChanged(String key) {
        assert (key != null);
        this.getNode().markAsDirty();
        Map<String, Serializable> changes = this.getChangeTracker();
        if (!changes.containsKey(key)) {
            if (this.values != null && this.values.containsKey(key)) {
                Serializable oldValue = this.values.get(key);
                changes.put(key, oldValue);
            } else {
                changes.put(key, REMOVED_MARKER);
            }
        }
    }

    private Map<String, Serializable> getChangeTracker() {
        return this.getNode().getChangeTracker(this, HashMap::new);
    }

    private void setAccessed(String key) {
        assert (key != null);
    }

    @Override
    public void collectChanges(Consumer<NodeChange> collector) {
        boolean hasChanges = false;
        for (Map.Entry<String, Serializable> entry : this.getChangeTracker().entrySet()) {
            boolean containedEarlier;
            String key = entry.getKey();
            Serializable value = entry.getValue();
            boolean containsNow = this.values != null && this.values.containsKey(key);
            boolean bl = containedEarlier = value != REMOVED_MARKER;
            if (containedEarlier && !containsNow) {
                collector.accept(new MapRemoveChange(this, key));
                hasChanges = true;
                continue;
            }
            if (!containsNow) continue;
            Serializable currentValue = this.values.get(key);
            if (containedEarlier && Objects.equals(value, currentValue)) continue;
            collector.accept(new MapPutChange(this, key, currentValue));
            hasChanges = true;
        }
        if (!this.isPopulated) {
            if (!hasChanges) {
                collector.accept(new EmptyChange(this));
            }
            this.isPopulated = true;
        }
    }

    @Override
    public void generateChangesFromEmpty() {
        if (this.values == null) {
            if (!this.isPopulated) {
                this.getChangeTracker();
            }
            return;
        }
        assert (!this.values.isEmpty());
        Map<String, Serializable> changes = this.getChangeTracker();
        this.values.keySet().forEach(k -> changes.put((String)k, REMOVED_MARKER));
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
        if (this.values == null) {
            return;
        }
        assert (!this.values.isEmpty());
        this.values.values().stream().filter(v -> v instanceof StateNode).forEach(v -> action.accept((StateNode)v));
    }

    public void updateFromClient(String key, Serializable value) {
        if (!this.mayUpdateFromClient(key, value)) {
            throw new IllegalArgumentException(String.format("Feature '%s' doesn't allow the client to update '%s'", this.getClass().getName(), key));
        }
        this.put(key, value, false);
    }

    protected boolean mayUpdateFromClient(String key, Serializable value) {
        return false;
    }
}

