/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ClientCallableHandlers;
import com.vaadin.flow.internal.nodefeature.PolymerServerEventHandlers;
import com.vaadin.flow.internal.nodefeature.ServerSideFeature;
import java.util.Optional;

public class ComponentMapping
extends ServerSideFeature {
    private Component component = null;

    protected ComponentMapping(StateNode node) {
        super(node);
    }

    public void setComponent(Component component) {
        assert (component != null) : "Component must not be null";
        assert (this.component == null || component instanceof Composite) : "Only a Composite is allowed to remap a component";
        this.component = component;
        if (this.getNode().hasFeature(ClientCallableHandlers.class)) {
            this.getNode().getFeature(ClientCallableHandlers.class).componentSet(component);
        }
        if (component instanceof PolymerTemplate && this.getNode().hasFeature(PolymerServerEventHandlers.class)) {
            this.getNode().getFeature(PolymerServerEventHandlers.class).componentSet((PolymerTemplate)component);
        }
    }

    public Optional<Component> getComponent() {
        return Optional.ofNullable(this.component);
    }

    @Override
    public void onAttach(boolean initialAttach) {
        this.getComponent().ifPresent(c -> ComponentUtil.onComponentAttach(c, initialAttach));
    }

    @Override
    public void onDetach() {
        this.getComponent().ifPresent(ComponentUtil::onComponentDetach);
    }
}

