/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ServerSideFeature;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AttachExistingElementFeature
extends ServerSideFeature {
    private Map<StateNode, ChildElementConsumer> callbacks;
    private Map<StateNode, Node<?>> parentNodes;
    private Map<StateNode, Element> siblings;

    public AttachExistingElementFeature(StateNode node) {
        super(node);
    }

    public void register(Node<?> parent, Element previousSibling, StateNode child, ChildElementConsumer callback) {
        if (this.callbacks == null) {
            this.callbacks = new HashMap<StateNode, ChildElementConsumer>();
        }
        if (this.parentNodes == null) {
            this.parentNodes = new HashMap();
        }
        if (this.siblings == null) {
            this.siblings = new HashMap<StateNode, Element>();
        }
        this.callbacks.put(child, callback);
        this.parentNodes.put(child, parent);
        this.siblings.put(child, previousSibling);
        child.setParent(this.getNode());
    }

    public ChildElementConsumer getCallback(StateNode node) {
        return this.callbacks.remove(node);
    }

    public Node<?> getParent(StateNode node) {
        return this.parentNodes.get(node);
    }

    public Element getPreviousSibling(StateNode node) {
        return this.siblings.get(node);
    }

    public void unregister(StateNode node) {
        this.callbacks.remove(node);
        this.parentNodes.remove(node);
        this.siblings.remove(node);
        node.setParent(null);
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
        if (this.callbacks != null) {
            this.callbacks.keySet().stream().forEach(action::accept);
        }
    }
}

