/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.internal.StateNode;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public abstract class AbstractTemplate<M>
extends Component {
    private final StateNode stateNode;

    protected AbstractTemplate() {
        this.stateNode = this.getElement().getNode();
    }

    protected AbstractTemplate(StateNode stateNode) {
        super(null);
        this.stateNode = stateNode;
    }

    protected abstract M getModel();

    protected Class<? extends M> getModelType() {
        Type type = GenericTypeReflector.getTypeParameter((Type)this.getClass().getGenericSuperclass(), AbstractTemplate.class.getTypeParameters()[0]);
        if (type instanceof Class || type instanceof ParameterizedType) {
            return GenericTypeReflector.erase((Type)type);
        }
        throw new IllegalStateException(AbstractTemplate.getExceptionMessage(type));
    }

    private static String getExceptionMessage(Type type) {
        if (type == null) {
            return "AbstractTemplate is used as raw type: either add type information or override getModelType().";
        }
        if (type instanceof TypeVariable) {
            return String.format("Could not determine the composite content type for TypeVariable '%s'. Either specify exact type or override getModelType().", type.getTypeName());
        }
        return String.format("Could not determine the composite content type for %s. Override getModelType().", type.getTypeName());
    }

    protected StateNode getStateNode() {
        return this.stateNode;
    }
}

