/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.html;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.ListItem;
import java.util.stream.Stream;

@Tag(value="ol")
public class OrderedList
extends HtmlContainer
implements ClickNotifier<OrderedList> {
    private static final PropertyDescriptor<String, String> typeDescriptor = PropertyDescriptors.attributeWithDefault((String)"type", (String)NumberingType.NUMBER.value);

    public OrderedList() {
    }

    public OrderedList(NumberingType type) {
        this.setType(type);
    }

    public OrderedList(ListItem ... items) {
        super((Component[])items);
    }

    public NumberingType getType() {
        String value = (String)this.get(typeDescriptor);
        try {
            return NumberingType.fromAttributeValue(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("The attribute type has an illegal value: " + value, e);
        }
    }

    public void setType(NumberingType type) {
        this.set(typeDescriptor, type.value);
    }

    public static enum NumberingType {
        NUMBER("1"),
        UPPERCASE_LETTER("A"),
        LOWERCASE_LETTER("a"),
        UPPERCASE_ROMAN("I"),
        LOWERCASE_ROMAN("i");

        private final String value;

        private NumberingType(String value) {
            this.value = value;
        }

        private static NumberingType fromAttributeValue(String value) {
            return Stream.of(NumberingType.values()).filter(type -> type.value.equals(value)).findFirst().orElseThrow(IllegalArgumentException::new);
        }
    }
}

