/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.ConfigurableFilterDataProviderWrapper;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalQuery;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import java.util.stream.Stream;

final class HierarchicalFilterUtils {
    private HierarchicalFilterUtils() {
    }

    private static <T, F, Q> HierarchicalQuery<T, F> adapt(HierarchicalQuery<T, Q> query, F filter) {
        return new HierarchicalQuery(query.getOffset(), query.getLimit(), query.getSortOrders(), query.getInMemorySorting(), filter, query.getParent());
    }

    static abstract class HierarchicalFilterDataProviderWrapper<T, F, M>
    extends DataProviderWrapper<T, F, M>
    implements HierarchicalDataProvider<T, F> {
        HierarchicalFilterDataProviderWrapper(HierarchicalDataProvider<T, M> dataProvider) {
            super(dataProvider);
        }

        @Override
        public int getChildCount(HierarchicalQuery<T, F> query) {
            return this.getDataProvider().getChildCount(HierarchicalFilterUtils.adapt(query, this.getFilter(query)));
        }

        @Override
        public Stream<T> fetchChildren(HierarchicalQuery<T, F> query) {
            return this.getDataProvider().fetchChildren(HierarchicalFilterUtils.adapt(query, this.getFilter(query)));
        }

        @Override
        public boolean hasChildren(T item) {
            return this.getDataProvider().hasChildren(item);
        }

        @Override
        public int size(Query<T, F> query) {
            return HierarchicalDataProvider.super.size(query);
        }

        @Override
        public Stream<T> fetch(Query<T, F> query) {
            return HierarchicalDataProvider.super.fetch(query);
        }

        @Override
        public <U, V> HierarchicalConfigurableFilterDataProvider<T, U, V> withConfigurableFilter(SerializableBiFunction<U, V, F> filterCombiner) {
            return HierarchicalDataProvider.super.withConfigurableFilter((SerializableBiFunction)filterCombiner);
        }

        @Override
        public <U> HierarchicalDataProvider<T, U> withConvertedFilter(SerializableFunction<U, F> filterConverter) {
            return HierarchicalDataProvider.super.withConvertedFilter((SerializableFunction)filterConverter);
        }

        @Override
        public HierarchicalConfigurableFilterDataProvider<T, Void, F> withConfigurableFilter() {
            return (HierarchicalConfigurableFilterDataProvider)super.withConfigurableFilter();
        }

        private HierarchicalDataProvider<T, M> getDataProvider() {
            return (HierarchicalDataProvider)this.dataProvider;
        }
    }

    static abstract class HierarchialConfigurableFilterDataProviderWrapper<T, Q, C, F>
    extends ConfigurableFilterDataProviderWrapper<T, Q, C, F>
    implements HierarchicalConfigurableFilterDataProvider<T, Q, C> {
        HierarchialConfigurableFilterDataProviderWrapper(HierarchicalDataProvider<T, F> dataProvider) {
            super(dataProvider);
        }

        @Override
        public int getChildCount(HierarchicalQuery<T, Q> query) {
            return this.getDataProvider().getChildCount(HierarchicalFilterUtils.adapt(query, this.getFilter(query)));
        }

        @Override
        public Stream<T> fetchChildren(HierarchicalQuery<T, Q> query) {
            return this.getDataProvider().fetchChildren(HierarchicalFilterUtils.adapt(query, this.getFilter(query)));
        }

        @Override
        public boolean hasChildren(T item) {
            return this.getDataProvider().hasChildren(item);
        }

        @Override
        public int size(Query<T, Q> t) {
            return HierarchicalConfigurableFilterDataProvider.super.size(t);
        }

        @Override
        public Stream<T> fetch(Query<T, Q> query) {
            return HierarchicalConfigurableFilterDataProvider.super.fetch(query);
        }

        @Override
        public <U, V> HierarchicalConfigurableFilterDataProvider<T, U, V> withConfigurableFilter(SerializableBiFunction<U, V, Q> filterCombiner) {
            return HierarchicalConfigurableFilterDataProvider.super.withConfigurableFilter((SerializableBiFunction)filterCombiner);
        }

        @Override
        public <U> HierarchicalDataProvider<T, U> withConvertedFilter(SerializableFunction<U, Q> filterConverter) {
            return HierarchicalConfigurableFilterDataProvider.super.withConvertedFilter((SerializableFunction)filterConverter);
        }

        @Override
        public HierarchicalConfigurableFilterDataProvider<T, Void, Q> withConfigurableFilter() {
            return (HierarchicalConfigurableFilterDataProvider)super.withConfigurableFilter();
        }

        private HierarchicalDataProvider<T, F> getDataProvider() {
            return (HierarchicalDataProvider)this.dataProvider;
        }
    }
}

