/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;

public abstract class WebSocketHandler
implements WebSocketProtocol {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandler.class);

    public void onByteMessage(WebSocket webSocket, byte[] data, int offset, int length) {
    }

    public void onTextMessage(WebSocket webSocket, String data) {
    }

    @Override
    public final void configure(AtmosphereConfig config) {
    }

    @Override
    public final List<AtmosphereRequest> onMessage(WebSocket webSocket, String data) {
        this.onTextMessage(webSocket, data);
        return null;
    }

    @Override
    public final List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        this.onByteMessage(webSocket, data, offset, length);
        return null;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        webSocket.resource().suspend(-1L);
    }

    @Override
    public void onClose(WebSocket webSocket) {
        webSocket.resource().resume();
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.error(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }
}

