/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.analytics;

import java.util.HashMap;
import java.util.Map;

public class ModuleDetection {
    private static final HashMap<String, String> modules = new HashMap();

    public static final String detect() {
        for (Map.Entry<String, String> e : modules.entrySet()) {
            if (!ModuleDetection.check(e.getValue())) continue;
            return e.getKey();
        }
        return "runtime";
    }

    static boolean check(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        modules.put("jersey", "org.atmosphere.jersey.AtmosphereFilter");
        modules.put("gwt", "org.atmosphere.gwt.serve.AtmosphereGwtHandler");
        modules.put("cometd", "org.atmosphere.cometd.CometdServlet");
        modules.put("socketio", "org.atmosphere.socketio.cpr.SocketIOAtmosphereHandler");
        modules.put("weblogic", "org.atmosphere.weblogic.AtmosphereWebLogicServlet");
    }
}

