/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;

public abstract class AbstractReflectorAtmosphereHandler
implements AtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReflectorAtmosphereHandler.class);

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object message = event.getMessage();
        AtmosphereResponse r = event.getResource().getResponse();
        if (message == null || event.isCancelled() || event.getResource().getRequest().destroyed()) {
            return;
        }
        if (event.getResource().getSerializer() != null) {
            try {
                if (message instanceof List) {
                    for (Object s : (List)message) {
                        event.getResource().getSerializer().write((OutputStream)event.getResource().getResponse().getOutputStream(), s);
                    }
                }
                event.getResource().getSerializer().write((OutputStream)event.getResource().getResponse().getOutputStream(), message);
            }
            catch (Throwable ex) {
                logger.warn("Serializer exception: message: " + message, ex);
                throw new IOException(ex);
            }
        } else {
            boolean isUsingStream = true;
            if (event.getResource().getRequest().getAttribute("org.atmosphere.useStream") != null) {
                isUsingStream = (Boolean)event.getResource().getRequest().getAttribute("org.atmosphere.useStream");
            }
            if (!isUsingStream) {
                try {
                    r.getWriter();
                }
                catch (IllegalStateException e) {
                    isUsingStream = true;
                }
            }
            if (message instanceof List) {
                for (String s : (List)message) {
                    if (isUsingStream) {
                        r.getOutputStream().write(s.getBytes(r.getCharacterEncoding()));
                        r.getOutputStream().flush();
                        continue;
                    }
                    r.getWriter().write(s);
                    r.getWriter().flush();
                }
            } else if (isUsingStream) {
                r.getOutputStream().write(message.toString().getBytes(r.getCharacterEncoding()));
                r.getOutputStream().flush();
            } else {
                r.getWriter().write(message.toString());
                r.getWriter().flush();
            }
        }
        this.postStateChange(event);
    }

    protected final void postStateChange(AtmosphereResourceEvent event) {
        Object o;
        if (event.isResuming()) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = r.getRequest(false).getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
            r.resume();
        }
    }
}

