/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container.version;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;
import org.eclipse.jetty.websocket.WebSocket;

public class Jetty8WebSocket
extends WebSocket {
    private static final Logger logger = LoggerFactory.getLogger(Jetty8WebSocket.class);
    private final WebSocket.Connection connection;
    private final AtomicBoolean firstWrite = new AtomicBoolean(false);

    public Jetty8WebSocket(WebSocket.Connection connection, AtmosphereConfig config) {
        super(config);
        this.connection = connection;
    }

    @Override
    public WebSocket writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        if (!this.firstWrite.get()) {
            logger.debug("The WebSocket handshake succeeded but the dispatched URI failed with status {} : {} The WebSocket connection is still open and client can continue sending messages.", (Object)(errorCode + " " + message), (Object)this.retrieveUUID());
        } else {
            logger.debug("{} {}", (Object)errorCode, (Object)message);
        }
        return this;
    }

    @Override
    public WebSocket redirect(AtmosphereResponse r, String location) throws IOException {
        logger.error("WebSocket Redirect not supported");
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, String data) throws IOException {
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        this.firstWrite.set(true);
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write()");
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data.getBytes(this.resource().getResponse().getCharacterEncoding()));
            if (b != null) {
                this.connection.sendMessage(b, 0, b.length);
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.connection.sendMessage(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data) throws IOException {
        this.firstWrite.set(true);
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        if (this.binaryWrite) {
            byte[] b = this.webSocketResponseFilter.filter(r, data);
            if (b != null) {
                this.connection.sendMessage(b, 0, b.length);
            }
        } else {
            byte[] s = this.webSocketResponseFilter.filter(r, data);
            if (s != null) {
                this.connection.sendMessage(new String(s, r.getCharacterEncoding()));
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public WebSocket write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        this.firstWrite.set(true);
        if (!this.connection.isOpen()) {
            throw new IOException("Connection remotely closed");
        }
        logger.trace("WebSocket.write() for {}", (Object)(this.resource() != null ? this.resource().uuid() : ""));
        if (this.binaryWrite) {
            if (!WebSocketResponseFilter.NoOpsWebSocketResponseFilter.class.isAssignableFrom(this.webSocketResponseFilter.getClass())) {
                byte[] b = this.webSocketResponseFilter.filter(r, data, offset, length);
                if (b != null) {
                    this.connection.sendMessage(b, 0, b.length);
                }
            } else {
                this.connection.sendMessage(data, offset, length);
            }
        } else {
            String s = this.webSocketResponseFilter.filter(r, new String(data, offset, length, "UTF-8"));
            if (s != null) {
                this.connection.sendMessage(s);
            }
        }
        this.lastWrite = System.currentTimeMillis();
        return this;
    }

    @Override
    public void close(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.close() for AtmosphereResource {}", (Object)(this.resource() != null ? this.resource().uuid() : "null"));
        this.connection.close();
    }

    @Override
    public WebSocket flush(AtmosphereResponse r) throws IOException {
        logger.trace("WebSocket.flush() not supported by Jetty");
        return this;
    }

    public String toString() {
        return this.connection.toString();
    }
}

