/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import org.atmosphere.container.JettyWebSocketUtil;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class JettyServlet30AsyncSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JettyServlet30AsyncSupportWithWebSocket.class);
    private final WebSocketFactory webSocketFactory;

    public JettyServlet30AsyncSupportWithWebSocket(AtmosphereConfig config) {
        super(config);
        WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        boolean isJetty = config.getServletContext().getServerInfo().toLowerCase().startsWith("jetty");
        this.webSocketFactory = isJetty ? JettyWebSocketUtil.getFactory(config, webSocketProcessor) : null;
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = JettyWebSocketUtil.doService(this, req, res, this.webSocketFactory);
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

