/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcasterCache;

public abstract class AbstractBroadcasterCache
implements BroadcasterCache {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractBroadcasterCache.class);
    protected final List<CachedMessage> queue = Collections.synchronizedList(new LinkedList());
    protected ScheduledExecutorService reaper = Executors.newSingleThreadScheduledExecutor();
    protected int maxCachedinMs = 300000;
    protected ScheduledFuture scheduledFuture;

    @Override
    public final void start() {
        this.scheduledFuture = this.reaper.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractBroadcasterCache abstractBroadcasterCache = AbstractBroadcasterCache.this;
                synchronized (abstractBroadcasterCache) {
                    Iterator<CachedMessage> i = AbstractBroadcasterCache.this.queue.iterator();
                    while (i.hasNext()) {
                        CachedMessage message = i.next();
                        logger.trace("Message: {}", message.message());
                        if (System.currentTimeMillis() - message.currentTime() <= (long)AbstractBroadcasterCache.this.maxCachedinMs) break;
                        logger.trace("Pruning: {}", message.message());
                        i.remove();
                    }
                }
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    public void setExecutorService(ScheduledExecutorService reaper) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        if (reaper != null) {
            this.stop();
        }
        this.reaper = reaper;
    }

    @Override
    public final void stop() {
        this.reaper.shutdown();
    }

    @Override
    public final synchronized void addToCache(String id, AtmosphereResource resource, Object object) {
        logger.trace("Adding message for resource: {}, object: {}", (Object)resource, object);
        CachedMessage cm = new CachedMessage(object, System.currentTimeMillis(), null);
        CachedMessage prev = null;
        if (!this.queue.isEmpty()) {
            prev = this.queue.get(this.queue.size() - 1);
        }
        if (prev != null) {
            prev.next(cm);
        }
        if (!this.queue.contains(cm)) {
            this.queue.add(cm);
        }
        if (prev == null) {
            cm = new CachedMessage(true);
        }
        this.cache(id, resource, cm);
    }

    public abstract void cache(String var1, AtmosphereResource var2, CachedMessage var3);

    public abstract CachedMessage retrieveLastMessage(String var1, AtmosphereResource var2);

    @Override
    public final synchronized List<Object> retrieveFromCache(String id, AtmosphereResource r) {
        CachedMessage cm = this.retrieveLastMessage(id, r);
        boolean isNew = false;
        if (cm == null && ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isInScope() && r.getRequest().getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) != null) {
            isNew = true;
        }
        boolean isHead = false;
        if (cm != null && cm.isTail) {
            cm = null;
        }
        if (cm != null) {
            if (!this.queue.contains(cm) && !this.queue.isEmpty()) {
                cm = this.queue.get(0);
                isHead = true;
            }
        } else if (isNew && !this.queue.isEmpty()) {
            cm = this.queue.get(0);
            isHead = true;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        if (cm == null) {
            return l;
        }
        if (!isHead) {
            cm = cm.next();
        }
        CachedMessage prev = cm;
        while (cm != null) {
            l.add(cm.message());
            prev = cm;
            cm = cm.next();
        }
        if (prev != null) {
            this.cache(id, r, prev);
        }
        return l;
    }

    public int getQueueDepth() {
        return this.queue.size();
    }

    public int getMaxCachedinMs() {
        return this.maxCachedinMs;
    }

    public void setMaxCachedinMs(int maxCachedinMs) {
        this.maxCachedinMs = maxCachedinMs;
    }

    protected static final class CachedMessage
    implements Serializable {
        public final Object message;
        public final long currentTime;
        public CachedMessage next;
        public final boolean isTail;
        public Object t;

        public CachedMessage(boolean isTail) {
            this.currentTime = System.currentTimeMillis();
            this.message = null;
            this.next = null;
            this.isTail = isTail;
        }

        public CachedMessage(Object message, long currentTime, CachedMessage next) {
            this.currentTime = currentTime;
            this.message = message;
            this.next = next;
            this.isTail = false;
        }

        public Object message() {
            return this.message;
        }

        public long currentTime() {
            return this.currentTime;
        }

        public CachedMessage next() {
            return this.next;
        }

        public CachedMessage next(CachedMessage next) {
            this.next = next;
            return next;
        }

        public String toString() {
            if (this.message != null) {
                return this.message.toString();
            }
            return "";
        }

        public boolean isTail() {
            return this.isTail;
        }

        public CachedMessage setKey(Object t) {
            this.t = t;
            return this;
        }

        public Object getKey() {
            return this.t;
        }
    }
}

