/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.context;

import com.uber.jaeger.context.Callable;
import com.uber.jaeger.context.Runnable;
import com.uber.jaeger.context.TraceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracedExecutorService
implements ExecutorService {
    private final ExecutorService delegate;
    private final TraceContext traceContext;

    public TracedExecutorService(ExecutorService delegate, TraceContext traceContext) {
        this.delegate = delegate;
        this.traceContext = traceContext;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<java.lang.Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(java.util.concurrent.Callable<T> task) {
        return this.delegate.submit(new Callable<T>(task, this.traceContext));
    }

    @Override
    public <T> Future<T> submit(java.lang.Runnable task, T result) {
        return this.delegate.submit(new Runnable(task, this.traceContext), result);
    }

    @Override
    public Future<?> submit(java.lang.Runnable task) {
        return this.delegate.submit(new Runnable(task, this.traceContext));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends java.util.concurrent.Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapJaegerCallableCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends java.util.concurrent.Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrapJaegerCallableCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends java.util.concurrent.Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrapJaegerCallableCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends java.util.concurrent.Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrapJaegerCallableCollection(tasks), timeout, unit);
    }

    @Override
    public void execute(java.lang.Runnable command) {
        this.delegate.execute(new Runnable(command, this.traceContext));
    }

    private <T> Collection<? extends java.util.concurrent.Callable<T>> wrapJaegerCallableCollection(Collection<? extends java.util.concurrent.Callable<T>> originalCollection) {
        ArrayList<Callable<T>> collection = new ArrayList<Callable<T>>(originalCollection.size());
        for (java.util.concurrent.Callable<T> c : originalCollection) {
            collection.add(new Callable<T>(c, this.traceContext));
        }
        return collection;
    }
}

