/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle4;

import com.trello.rxlifecycle4.Functions;
import com.trello.rxlifecycle4.LifecycleTransformer;
import com.trello.rxlifecycle4.internal.Preconditions;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class RxLifecycle {
    private RxLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    @Nonnull
    @CheckReturnValue
    public static <T, R> LifecycleTransformer<T> bindUntilEvent(@Nonnull Observable<R> lifecycle, @Nonnull R event) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        Preconditions.checkNotNull(event, "event == null");
        return RxLifecycle.bind(RxLifecycle.takeUntilEvent(lifecycle, event));
    }

    private static <R> Observable<R> takeUntilEvent(Observable<R> lifecycle, final R event) {
        return lifecycle.filter(new Predicate<R>(){

            public boolean test(R lifecycleEvent) throws Exception {
                return lifecycleEvent.equals(event);
            }
        });
    }

    @Nonnull
    @CheckReturnValue
    public static <T, R> LifecycleTransformer<T> bind(@Nonnull Observable<R> lifecycle) {
        return new LifecycleTransformer(lifecycle);
    }

    @Nonnull
    @CheckReturnValue
    public static <T, R> LifecycleTransformer<T> bind(@Nonnull Observable<R> lifecycle, @Nonnull Function<R, R> correspondingEvents) {
        Preconditions.checkNotNull(lifecycle, "lifecycle == null");
        Preconditions.checkNotNull(correspondingEvents, "correspondingEvents == null");
        return RxLifecycle.bind(RxLifecycle.takeUntilCorrespondingEvent(lifecycle.share(), correspondingEvents));
    }

    private static <R> Observable<Boolean> takeUntilCorrespondingEvent(Observable<R> lifecycle, Function<R, R> correspondingEvents) {
        return Observable.combineLatest((ObservableSource)lifecycle.take(1L).map(correspondingEvents), (ObservableSource)lifecycle.skip(1L), (BiFunction)new BiFunction<R, R, Boolean>(){

            public Boolean apply(R bindUntilEvent, R lifecycleEvent) throws Exception {
                return lifecycleEvent.equals(bindUntilEvent);
            }
        }).onErrorReturn(Functions.RESUME_FUNCTION).filter(Functions.SHOULD_COMPLETE);
    }
}

