/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle4;

import com.trello.rxlifecycle4.Functions;
import com.trello.rxlifecycle4.internal.Preconditions;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.reactivestreams.Publisher;

@ParametersAreNonnullByDefault
public final class LifecycleTransformer<T>
implements ObservableTransformer<T, T>,
FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer {
    final Observable<?> observable;

    LifecycleTransformer(Observable<?> observable) {
        Preconditions.checkNotNull(observable, "observable == null");
        this.observable = observable;
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return upstream.takeUntil(this.observable);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return upstream.takeUntil((Publisher)this.observable.toFlowable(BackpressureStrategy.LATEST));
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return upstream.takeUntil((SingleSource)this.observable.firstOrError());
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return upstream.takeUntil((MaybeSource)this.observable.firstElement());
    }

    public CompletableSource apply(Completable upstream) {
        return Completable.ambArray((CompletableSource[])new CompletableSource[]{upstream, this.observable.flatMapCompletable(Functions.CANCEL_COMPLETABLE)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleTransformer that = (LifecycleTransformer)o;
        return this.observable.equals(that.observable);
    }

    public int hashCode() {
        return this.observable.hashCode();
    }

    public String toString() {
        return "LifecycleTransformer{observable=" + this.observable + '}';
    }
}

