/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.maven;

import com.tngtech.jgiven.report.ReportGenerator;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class JGivenReportMojo
extends AbstractMojo {
    private File outputDirectory;
    private File sourceDirectory;
    private File customCssFile;
    private File customJsFile;
    private String format;
    private String title;
    boolean excludeEmptyScenarios;

    public void execute() throws MojoExecutionException {
        try {
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Error while trying to create output directory " + this.outputDirectory);
            }
            this.getLog().info((CharSequence)("JGiven HTML report source directory: " + this.sourceDirectory));
            this.getLog().info((CharSequence)("JGiven HTML report output directory: " + this.outputDirectory));
            if (this.customCssFile != null && this.customCssFile.exists()) {
                this.getLog().info((CharSequence)("JGiven HTML report custom CSS file: " + this.customCssFile));
            }
            if (this.customJsFile != null && this.customJsFile.exists()) {
                this.getLog().info((CharSequence)("JGiven HTML report custom JS file: " + this.customJsFile));
            }
            this.getLog().info((CharSequence)("Generating HTML reports to " + this.outputDirectory + "..."));
            ReportGenerator generator = new ReportGenerator();
            generator.setTargetDirectory(this.outputDirectory);
            generator.setSourceDirectory(this.sourceDirectory);
            generator.setFormat(ReportGenerator.Format.fromStringOrNull((String)this.format));
            generator.getConfig().setCustomCssFile(this.customCssFile);
            generator.getConfig().setCustomJsFile(this.customJsFile);
            generator.getConfig().setTitle(this.title);
            generator.getConfig().setExcludeEmptyScenarios(this.excludeEmptyScenarios);
            generator.generate();
            this.getLog().info((CharSequence)"-------------------------------------------------------------------");
            this.getLog().info((CharSequence)("Generated JGiven HTML reports to directory " + this.outputDirectory));
            this.getLog().info((CharSequence)"-------------------------------------------------------------------");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while trying to generate HTML reports", e);
        }
    }
}

