/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util.cache;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedItem<T>
implements Delayed {
    private T t;
    private long liveTime;
    private long removeTime;

    public DelayedItem(T t, long liveTime) {
        this.setT(t);
        this.liveTime = liveTime;
        this.removeTime = TimeUnit.NANOSECONDS.convert(liveTime, TimeUnit.NANOSECONDS) + System.nanoTime();
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        if (o instanceof DelayedItem) {
            DelayedItem tmpDelayedItem = (DelayedItem)o;
            return Long.compare(this.liveTime, tmpDelayedItem.liveTime);
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
        return diff > 0L ? 1 : (diff == 0L ? 0 : -1);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.removeTime - System.nanoTime(), unit);
    }

    public T getT() {
        return this.t;
    }

    public void setT(T t) {
        this.t = t;
    }

    public int hashCode() {
        return this.t.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DelayedItem) {
            return object.hashCode() == this.hashCode();
        }
        return false;
    }
}

