/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util.cache;

import com.tlcsdm.common.util.cache.DelayedItem;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;

public class DelayCache<K, V> {
    public static DelayCache<String, Object> DELAY_CACHE = new DelayCache();
    private ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    private DelayQueue<DelayedItem<K>> queue = new DelayQueue();
    public static final long CACHE_HOLD_30SECOND = 30000000000L;
    public static final long CACHE_HOLD_30MINUTE = 1800000000000L;
    public static final long CACHE_HOLD_1DAY = 500654080000L;
    public static final long CACHE_HOLD_FOREVER = Long.MAX_VALUE;

    public void put(K k, V v, long liveTime) {
        V v2 = this.map.put(k, v);
        DelayedItem<K> tmpItem = new DelayedItem<K>(k, liveTime);
        if (v2 != null) {
            this.queue.remove(tmpItem);
        }
        this.queue.put(tmpItem);
    }

    public void put(K k, V v) {
        this.put(k, v, 1800000000000L);
    }

    public void clear() {
        this.queue.clear();
        this.map.clear();
    }

    public void remove(K k, long liveTime) {
        DelayedItem<K> tmpItem = new DelayedItem<K>(k, liveTime);
        V v2 = this.map.get(k);
        if (v2 != null) {
            this.queue.remove(tmpItem);
            this.map.remove(k);
        }
    }

    public void remove(K k) {
        DelayedItem<K> tmpItem = new DelayedItem<K>(k, 1800000000000L);
        V v2 = this.map.get(k);
        if (v2 != null) {
            this.queue.remove(tmpItem);
            this.map.remove(k);
        }
    }

    public V get(String cacheName) {
        return this.map.get(cacheName);
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public DelayCache() {
        Thread t = new Thread(){

            @Override
            public void run() {
                DelayCache.this.checkOverdueKey();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void checkOverdueKey() {
        while (true) {
            DelayedItem delayedItem;
            if ((delayedItem = (DelayedItem)this.queue.poll()) != null) {
                this.map.remove(delayedItem.getT());
            }
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

