/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util;

import com.tlcsdm.common.base.BaseUtils;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public class ThreadMdcUtil {
    public static void setTraceIdIfAbsent() {
        if (MDC.get((String)BaseUtils.TRACE_ID) == null) {
            MDC.put((String)BaseUtils.TRACE_ID, (String)BaseUtils.getUuid());
        }
    }

    public static <T> Callable<T> wrap(Callable<T> callable, Map<String, String> context) {
        return () -> {
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            ThreadMdcUtil.setTraceIdIfAbsent();
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        };
    }

    public static Runnable wrap(Runnable runnable, Map<String, String> context) {
        return () -> {
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            ThreadMdcUtil.setTraceIdIfAbsent();
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }
}

