/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util;

import com.tlcsdm.common.base.BaseUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.converter.core.BasicURIResolver;
import org.apache.poi.xwpf.converter.core.FileImageExtractor;
import org.apache.poi.xwpf.converter.core.IImageExtractor;
import org.apache.poi.xwpf.converter.core.IURIResolver;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.xhtml.XHTMLConverter;
import org.apache.poi.xwpf.converter.xhtml.XHTMLOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.w3c.dom.Document;

public class PoiUtil {
    private static final String[] bordesr = new String[]{"border-top:", "border-right:", "border-bottom:", "border-left:"};
    private static final String[] borderStyles = new String[]{"solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid", "solid", "solid", "solid", "solid"};

    public static String wordToHtml(InputStream inputStream, String filePath, String reqUrl) throws IOException, ParserConfigurationException, TransformerException {
        HWPFDocument wordDoc = new HWPFDocument(inputStream);
        WordToHtmlConverter wthc = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        wthc.setPicturesManager((bytes, pt, string, f, f1) -> reqUrl + File.separator + string);
        wthc.processDocument((HWPFDocumentCore)wordDoc);
        List pics = wordDoc.getPicturesTable().getAllPictures();
        if (null != pics && pics.size() > 0) {
            for (Picture pic : pics) {
                pic.writeImageContent((OutputStream)new FileOutputStream(filePath + File.separator + pic.suggestFullFileName()));
            }
        }
        Document htmlDocument = wthc.getDocument();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(htmlDocument);
        StreamResult streamResult = new StreamResult(out);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("method", "html");
        serializer.transform(domSource, streamResult);
        out.close();
        inputStream.close();
        return out.toString();
    }

    public static String wordDocxToHtml(InputStream inputStream, String filePath, String reqUrl) throws IOException {
        XWPFDocument document = new XWPFDocument(inputStream);
        File imageFolderFile = new File(filePath);
        XHTMLOptions options = XHTMLOptions.create().URIResolver((IURIResolver)new BasicURIResolver(reqUrl));
        options.setExtractor((IImageExtractor)new FileImageExtractor(imageFolderFile));
        options.setIgnoreStylesIfUnused(false);
        options.setFragment(true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XHTMLConverter.getInstance().convert(document, (OutputStream)baos, (Options)options);
        String content = baos.toString();
        baos.close();
        inputStream.close();
        return content;
    }

    public static String convertExcelToHtml(InputStream inputStream) throws Exception {
        String excelHtml = null;
        Workbook wb = WorkbookFactory.create((InputStream)inputStream);
        if (wb instanceof XSSFWorkbook) {
            XSSFWorkbook xWb = (XSSFWorkbook)wb;
            excelHtml = PoiUtil.getExcelHtml((Workbook)xWb, true);
        }
        if (wb instanceof HSSFWorkbook) {
            HSSFWorkbook hWb = (HSSFWorkbook)wb;
            excelHtml = PoiUtil.getExcelHtml((Workbook)hWb, true);
        }
        inputStream.close();
        return excelHtml;
    }

    public static String convertExcelToHtmlByWb(Workbook workbook) {
        return PoiUtil.getExcelHtml(workbook, true);
    }

    public static String getExcelHtml(Workbook wb, boolean isWithStyle) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            Sheet sheet = wb.getSheetAt(i);
            Map<String, List<org.apache.poi.ss.usermodel.Picture>> sheetPictureMap = PoiUtil.getSheetPictrues(sheet, wb);
            int lastRowNum = sheet.getLastRowNum();
            Map<String, String>[] map = PoiUtil.getRowSpanColSpanMap(sheet);
            sb.append("<table style='border-collapse:collapse;' width='100%'>");
            Row row = null;
            Cell cell = null;
            for (int rowNum = sheet.getFirstRowNum(); rowNum <= lastRowNum; ++rowNum) {
                row = sheet.getRow(rowNum);
                if (row == null) {
                    sb.append("<tr><td > &nbsp;</td></tr>");
                    continue;
                }
                sb.append("<tr>");
                int lastColNum = row.getLastCellNum();
                for (int colNum = 0; colNum < lastColNum; ++colNum) {
                    cell = row.getCell(colNum);
                    if (cell == null) {
                        sb.append("<td align='left' valign='center' style='border: 1px solid rgb(0, 0, 0); width: 2304px; font-size: 110%; font-weight: 400;'>&nbsp;</td>");
                        continue;
                    }
                    String pictureKey = rowNum + "," + colNum;
                    String pictureHtml = "";
                    boolean hasPicture = false;
                    if (sheetPictureMap.containsKey(pictureKey)) {
                        List<org.apache.poi.ss.usermodel.Picture> pictureList = sheetPictureMap.get(pictureKey);
                        for (org.apache.poi.ss.usermodel.Picture picture : pictureList) {
                        }
                        hasPicture = true;
                    }
                    String stringValue = BaseUtils.getCellValue(cell);
                    if (map[0].containsKey(rowNum + "," + colNum)) {
                        String pointString = map[0].get(rowNum + "," + colNum);
                        map[0].remove(rowNum + "," + colNum);
                        int bottomeRow = Integer.parseInt(pointString.split(",")[0]);
                        int bottomeCol = Integer.parseInt(pointString.split(",")[1]);
                        int rowSpan = bottomeRow - rowNum + 1;
                        int colSpan = bottomeCol - colNum + 1;
                        sb.append("<td rowspan= '").append(rowSpan).append("' colspan= '").append(colSpan).append("' ");
                    } else {
                        if (map[1].containsKey(rowNum + "," + colNum)) {
                            map[1].remove(rowNum + "," + colNum);
                            continue;
                        }
                        sb.append("<td ");
                    }
                    if (isWithStyle) {
                        PoiUtil.dealExcelStyle(wb, sheet, cell, sb, hasPicture);
                    }
                    sb.append(">");
                    if (sheetPictureMap.containsKey(pictureKey)) {
                        sb.append(pictureHtml);
                    }
                    if ((stringValue == null || "".equals(stringValue.trim())) && !row.getZeroHeight()) {
                        sb.append(" &nbsp; ");
                    } else {
                        sb.append(stringValue.replace(String.valueOf('\u00a0'), "&nbsp;"));
                    }
                    sb.append("</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
            sb.append("<br /><br />");
        }
        return sb.toString();
    }

    private static Map<String, String>[] getRowSpanColSpanMap(Sheet sheet) {
        HashMap<CallSite, CallSite> map0 = new HashMap<CallSite, CallSite>();
        HashMap<CallSite, String> map1 = new HashMap<CallSite, String>();
        int mergedNum = sheet.getNumMergedRegions();
        CellRangeAddress range = null;
        for (int i = 0; i < mergedNum; ++i) {
            range = sheet.getMergedRegion(i);
            int topRow = range.getFirstRow();
            int topCol = range.getFirstColumn();
            int bottomRow = range.getLastRow();
            int bottomCol = range.getLastColumn();
            map0.put((CallSite)((Object)(topRow + "," + topCol)), (CallSite)((Object)(bottomRow + "," + bottomCol)));
            for (int tempRow = topRow; tempRow <= bottomRow; ++tempRow) {
                for (int tempCol = topCol; tempCol <= bottomCol; ++tempCol) {
                    map1.put((CallSite)((Object)(tempRow + "," + tempCol)), "");
                }
            }
            map1.remove(topRow + "," + topCol);
        }
        return new Map[]{map0, map1};
    }

    private static void dealExcelStyle(Workbook wb, Sheet sheet, Cell cell, StringBuffer sb, Boolean hasPicture) {
        CellStyle cellStyle;
        boolean rowInvisible = sheet.getRow(cell.getRowIndex()).getZeroHeight();
        int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
        int columnHeight = (int)((double)sheet.getRow(cell.getRowIndex()).getHeight() / 15.625);
        if (rowInvisible) {
            columnHeight = 0;
        }
        if ((cellStyle = cell.getCellStyle()) != null) {
            short alignment = cellStyle.getAlignment().getCode();
            sb.append("align='" + PoiUtil.convertAlignToHtml(alignment) + "' ");
            short verticalAlignment = cellStyle.getVerticalAlignment().getCode();
            sb.append("valign='" + PoiUtil.convertVerticalAlignToHtml(verticalAlignment) + "' ");
            if (wb instanceof XSSFWorkbook) {
                XSSFColor bgColor;
                XSSFColor xc;
                XSSFFont xf = ((XSSFCellStyle)cellStyle).getFont();
                short boldWeight = PoiUtil.getBoldweight(xf.getBold());
                sb.append("style='");
                sb.append("font-weight:").append(boldWeight).append(";");
                sb.append("font-size: " + (double)xf.getFontHeight() / 1.5 + "%;");
                sb.append("width:" + columnWidth + "px;");
                sb.append("height:" + columnHeight + "px;");
                if (hasPicture.booleanValue()) {
                    sb.append("height:" + columnHeight + "px;position:relative;");
                }
                if ((xc = xf.getXSSFColor()) != null && !"".equals(xc)) {
                    sb.append("color:#" + xc.getARGBHex().substring(2) + ";");
                }
                if ((bgColor = (XSSFColor)cellStyle.getFillForegroundColorColor()) != null) {
                    sb.append("background-color:#" + bgColor.getARGBHex().substring(2) + ";");
                }
                if (!rowInvisible) {
                    sb.append(PoiUtil.getBorderStyle(0, cellStyle.getBorderTop().getCode(), ((XSSFCellStyle)cellStyle).getTopBorderXSSFColor()));
                    sb.append(PoiUtil.getBorderStyle(1, cellStyle.getBorderRight().getCode(), ((XSSFCellStyle)cellStyle).getRightBorderXSSFColor()));
                    sb.append(PoiUtil.getBorderStyle(2, cellStyle.getBorderBottom().getCode(), ((XSSFCellStyle)cellStyle).getBottomBorderXSSFColor()));
                    sb.append(PoiUtil.getBorderStyle(3, cellStyle.getBorderLeft().getCode(), ((XSSFCellStyle)cellStyle).getLeftBorderXSSFColor()));
                }
            } else if (wb instanceof HSSFWorkbook) {
                short bgColor;
                String bgColorStr;
                HSSFFont hf = ((HSSFCellStyle)cellStyle).getFont(wb);
                short boldWeight = PoiUtil.getBoldweight(hf.getBold());
                short fontColor = hf.getColor();
                sb.append("style='");
                HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
                HSSFColor hc = palette.getColor(fontColor);
                sb.append("font-weight:").append(boldWeight).append(";");
                sb.append("font-size: " + (double)hf.getFontHeight() / 1.5 + "%;");
                String fontColorStr = PoiUtil.convertToStardColor(hc);
                if (fontColorStr != null && !"".equals(fontColorStr.trim())) {
                    sb.append("color:" + fontColorStr + ";");
                }
                sb.append("width:" + columnWidth + "px;");
                sb.append("height:" + columnHeight + "px;");
                if (hasPicture.booleanValue()) {
                    sb.append("height:" + columnHeight + "px;position:relative;");
                }
                if ((bgColorStr = PoiUtil.convertToStardColor(hc = palette.getColor(bgColor = cellStyle.getFillForegroundColor()))) != null && !"".equals(bgColorStr.trim())) {
                    sb.append("background-color:" + bgColorStr + ";");
                }
                if (!rowInvisible) {
                    sb.append(PoiUtil.getBorderStyle(palette, 0, cellStyle.getBorderTop().getCode(), cellStyle.getTopBorderColor()));
                    sb.append(PoiUtil.getBorderStyle(palette, 1, cellStyle.getBorderRight().getCode(), cellStyle.getRightBorderColor()));
                    sb.append(PoiUtil.getBorderStyle(palette, 3, cellStyle.getBorderLeft().getCode(), cellStyle.getLeftBorderColor()));
                    sb.append(PoiUtil.getBorderStyle(palette, 2, cellStyle.getBorderBottom().getCode(), cellStyle.getBottomBorderColor()));
                }
            }
            sb.append("' ");
        }
    }

    private static String convertAlignToHtml(short alignment) {
        String align = "left";
        switch (HorizontalAlignment.forInt((int)alignment)) {
            case LEFT: {
                align = "left";
                break;
            }
            case CENTER: {
                align = "center";
                break;
            }
            case RIGHT: {
                align = "right";
                break;
            }
        }
        return align;
    }

    private static String convertVerticalAlignToHtml(short verticalAlignment) {
        String valign = "middle";
        switch (VerticalAlignment.forInt((int)verticalAlignment)) {
            case BOTTOM: {
                valign = "bottom";
                break;
            }
            case CENTER: {
                valign = "center";
                break;
            }
            case TOP: {
                valign = "top";
                break;
            }
        }
        return valign;
    }

    private static String convertToStardColor(HSSFColor hc) {
        StringBuffer sb = new StringBuffer();
        if (hc != null) {
            if (IndexedColors.AUTOMATIC.index == hc.getIndex()) {
                return null;
            }
            sb.append("#");
            for (int i = 0; i < hc.getTriplet().length; ++i) {
                sb.append(BaseUtils.fillWithZero(Integer.toHexString(hc.getTriplet()[i])));
            }
        }
        return sb.toString();
    }

    private static String getBorderStyle(HSSFPalette palette, int b, short s, short t) {
        if (s == 0) {
            return bordesr[b] + borderStyles[s] + "#d0d7e5 0px;";
        }
        String borderColorStr = PoiUtil.convertToStardColor(palette.getColor(t));
        borderColorStr = borderColorStr == null || borderColorStr.length() < 1 ? "#000000" : borderColorStr;
        return bordesr[b] + borderStyles[s] + borderColorStr + " 1px;";
    }

    private static String getBorderStyle(int b, short s, XSSFColor xc) {
        if (s == 0) {
            return bordesr[b] + borderStyles[s] + "#d0d7e5 0px;";
        }
        if (xc != null) {
            String borderColorStr = xc.getARGBHex();
            borderColorStr = borderColorStr == null || borderColorStr.length() < 1 ? "#000000" : borderColorStr.substring(2);
            return bordesr[b] + borderStyles[s] + borderColorStr + " 1px;";
        }
        return "";
    }

    public static Map<String, List<org.apache.poi.ss.usermodel.Picture>> getSheetPictrues(Sheet sheet, Workbook workbook) {
        if (workbook instanceof XSSFWorkbook) {
            return PoiUtil.getSheetPictureMap2007((XSSFSheet)sheet);
        }
        if (workbook instanceof HSSFWorkbook) {
            return PoiUtil.getSheetPictrues2003((HSSFSheet)sheet);
        }
        return null;
    }

    private static Map<String, List<org.apache.poi.ss.usermodel.Picture>> getSheetPictureMap2007(XSSFSheet sheet) {
        HashMap<String, List<org.apache.poi.ss.usermodel.Picture>> sheetPictureMap = new HashMap<String, List<org.apache.poi.ss.usermodel.Picture>>();
        for (POIXMLDocumentPart documentPart : sheet.getRelations()) {
            if (!(documentPart instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)documentPart;
            List shapeList = drawing.getShapes();
            for (XSSFShape shape : shapeList) {
                XSSFPicture picture = (XSSFPicture)shape;
                XSSFClientAnchor anchor = picture.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                String pictureKey = ctMarker.getRow() + "," + ctMarker.getCol();
                List pictureList = sheetPictureMap.computeIfAbsent(pictureKey, k -> new ArrayList());
                pictureList.add(picture);
            }
        }
        return sheetPictureMap;
    }

    private static Map<String, List<org.apache.poi.ss.usermodel.Picture>> getSheetPictrues2003(HSSFSheet sheet) {
        HashMap<String, List<org.apache.poi.ss.usermodel.Picture>> sheetPictureMap = new HashMap<String, List<org.apache.poi.ss.usermodel.Picture>>();
        HSSFPatriarch hssfPatriarch = sheet.getDrawingPatriarch();
        if (hssfPatriarch != null) {
            List shapes = hssfPatriarch.getChildren();
            for (HSSFShape sp : shapes) {
                HSSFPicture picture;
                if (!(sp instanceof HSSFPicture) || !((picture = (HSSFPicture)sp).getAnchor() instanceof HSSFClientAnchor)) continue;
                HSSFClientAnchor anchor = (HSSFClientAnchor)picture.getAnchor();
                String pictureKey = anchor.getRow1() + "," + String.valueOf(anchor.getCol1());
                List pictureList = sheetPictureMap.computeIfAbsent(pictureKey, k -> new ArrayList());
                pictureList.add(picture);
            }
        }
        return sheetPictureMap;
    }

    public static byte[] bufferedImageToBytes(BufferedImage bufferedImage, String imageFormat) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, imageFormat, byteArrayOutputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void drawStringInCell(Graphics2D g2d, String text, int x, int y, int width, int height, String valign, Font font) {
        String[] texts;
        g2d.setFont(font);
        FontMetrics fontMetrics = g2d.getFontMetrics(font);
        int textWidth = fontMetrics.stringWidth(text);
        int textHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
        int lineNum = 1;
        if ((double)textWidth > (double)width * 0.98) {
            lineNum = (int)Math.ceil((double)textWidth / ((double)width * 0.98));
            int length = (int)((double)width * 0.98 / (double)textWidth * (double)text.length());
            texts = new String[lineNum];
            for (int i = 0; i < lineNum; ++i) {
                texts[i] = i < lineNum - 1 ? text.substring(length * i, length * (i + 1)) : text.substring(length * i);
            }
        } else {
            texts = new String[]{text};
        }
        for (int i = 0; i < lineNum; ++i) {
            int textX = (width - fontMetrics.stringWidth(texts[i])) / 2 + x;
            int textY = "top".equals(valign) ? textHeight * i + y + fontMetrics.getAscent() : ("bottom".equals(valign) ? height - textHeight * lineNum + textHeight * i + y + fontMetrics.getAscent() : (height - textHeight * lineNum) / 2 + textHeight * i + y + fontMetrics.getAscent());
            g2d.drawString(texts[i], textX, textY);
        }
    }

    public static BufferedImage applyShadow(BufferedImage bufferedImage, int size, Color color, float alpha) {
        BufferedImage result = PoiUtil.createCompatibleImage(bufferedImage, bufferedImage.getWidth() + size * 2, bufferedImage.getHeight() + size * 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)PoiUtil.generateShadow(bufferedImage, size, color, alpha), size, size, null);
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return result;
    }

    private static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return PoiUtil.getGraphicsConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    private static BufferedImage createCompatibleImage(int width, int height) {
        return PoiUtil.createCompatibleImage(width, height, 3);
    }

    private static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        BufferedImage image = PoiUtil.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
        image.coerceData(true);
        return image;
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static BufferedImage generateShadow(BufferedImage imgSource, int size, Color color, float alpha) {
        int imgWidth = imgSource.getWidth() + size * 2;
        int imgHeight = imgSource.getHeight() + size * 2;
        BufferedImage imgMask = PoiUtil.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2d = imgMask.createGraphics();
        PoiUtil.applyQualityRenderingHints(g2d);
        int x = Math.round((float)(imgWidth - imgSource.getWidth()) / 2.0f);
        int y = Math.round((float)(imgHeight - imgSource.getHeight()) / 2.0f);
        g2d.drawImage((Image)imgSource, x, y, null);
        g2d.dispose();
        return PoiUtil.generateBlur(imgMask, size * 2, color, alpha);
    }

    private static void applyQualityRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    private static BufferedImage generateBlur(BufferedImage imgSource, int size, Color color, float alpha) {
        int imgWidth = imgSource.getWidth();
        int imgHeight = imgSource.getHeight();
        BufferedImage imgBlur = PoiUtil.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgBlur.createGraphics();
        PoiUtil.applyQualityRenderingHints(g2);
        g2.drawImage((Image)imgSource, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(5, alpha));
        g2.setColor(color);
        g2.fillRect(0, 0, imgSource.getWidth(), imgSource.getHeight());
        g2.dispose();
        return imgBlur;
    }

    private static short getBoldweight(boolean hasBold) {
        return (short)(hasBold ? 700 : 400);
    }
}

