/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util;

import com.tlcsdm.common.base.BaseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class ListToTreeUtil {
    private static final int FILL_PALL = 500;
    private static final boolean DEFAULT_DEEP = false;
    private static final String DEFAULT_LEAF_KEY = "leaf";

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, Function<Map<String, Object>, ?> idFun, Function<Map<String, Object>, ?> pidFun, String leafKey, boolean deepClone) {
        ArrayList<Map<String, Object>> children;
        if (Objects.isNull(list) || Objects.isNull(isRoot) || Objects.isNull(idFun) || Objects.isNull(pidFun)) {
            return new ArrayList<Map<String, Object>>();
        }
        List cloneList = list;
        if (deepClone) {
            cloneList = (List)BaseUtils.deepClone(list);
        }
        if (list.size() > 500) {
            children = Collections.synchronizedList(new ArrayList());
            List finalCloneList = Collections.synchronizedList(cloneList);
            cloneList.parallelStream().filter(isRoot).forEachOrdered(s -> {
                children.add((Map<String, Object>)s);
                ListToTreeUtil.fillChild(s, finalCloneList, idFun, pidFun, leafKey);
            });
        } else {
            children = new ArrayList();
            for (Map child : cloneList) {
                if (!isRoot.test(child)) continue;
                children.add(child);
                ListToTreeUtil.fillChild(child, cloneList, idFun, pidFun, leafKey);
            }
        }
        return children;
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, String idField, String pidField, String leafKey, boolean deepClone) {
        return ListToTreeUtil.listToTree(list, isRoot, (Map<String, Object> m) -> m.get(idField), (Map<String, Object> n) -> n.get(pidField), leafKey, deepClone);
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, String idField, String pidField) {
        return ListToTreeUtil.listToTree(list, isRoot, idField, pidField, DEFAULT_LEAF_KEY, false);
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, String idField, String pidField, String leafKey) {
        return ListToTreeUtil.listToTree(list, isRoot, idField, pidField, leafKey, false);
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, String idField, String pidField, boolean deepClone) {
        return ListToTreeUtil.listToTree(list, isRoot, idField, pidField, DEFAULT_LEAF_KEY, deepClone);
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, Function<Map<String, Object>, ?> idFun, Function<Map<String, Object>, ?> pidFun) {
        return ListToTreeUtil.listToTree(list, isRoot, idFun, pidFun, DEFAULT_LEAF_KEY, false);
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, Function<Map<String, Object>, ?> idFun, Function<Map<String, Object>, ?> pidFun, String leafKey) {
        return ListToTreeUtil.listToTree(list, isRoot, idFun, pidFun, leafKey, false);
    }

    public static List<Map<String, Object>> listToTree(List<Map<String, Object>> list, Predicate<Map<String, Object>> isRoot, Function<Map<String, Object>, ?> idFun, Function<Map<String, Object>, ?> pidFun, boolean deepClone) {
        return ListToTreeUtil.listToTree(list, isRoot, idFun, pidFun, DEFAULT_LEAF_KEY, deepClone);
    }

    private static void fillChild(Map<String, Object> child, List<Map<String, Object>> list, Function<Map<String, Object>, ?> idFun, Function<Map<String, Object>, ?> pidFun, String leafKey) {
        List<Map<String, Object>> children;
        if (list.size() > 500) {
            children = Collections.synchronizedList(new ArrayList());
            list.parallelStream().filter(s -> idFun.apply(child).equals(pidFun.apply((Map<String, Object>)s))).forEachOrdered(s -> {
                children.add((Map<String, Object>)s);
                ListToTreeUtil.fillChild(s, list, idFun, pidFun, leafKey);
            });
        } else {
            children = new ArrayList();
            for (Map<String, Object> childDiv : list) {
                if (!idFun.apply(child).equals(pidFun.apply(childDiv))) continue;
                children.add(childDiv);
                ListToTreeUtil.fillChild(childDiv, list, idFun, pidFun, leafKey);
            }
        }
        if (children.size() == 0) {
            child.put(leafKey, true);
        }
        child.put("children", children);
    }
}

