/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalBuilder {
    private BigDecimal bigDecimal;
    private final int DEF_DIV_SCALE = 2;

    private BigDecimalBuilder(int i) {
        this.bigDecimal = new BigDecimal(i);
    }

    private BigDecimalBuilder(String str) {
        this.bigDecimal = new BigDecimal(str);
    }

    private BigDecimalBuilder(double d) {
        this.bigDecimal = new BigDecimal(d);
    }

    private void set(BigDecimal decimal) {
        this.bigDecimal = decimal;
    }

    public static BigDecimalBuilder builder(int i) {
        return new BigDecimalBuilder(i);
    }

    public static BigDecimalBuilder builder(String str) {
        return new BigDecimalBuilder(str);
    }

    public static BigDecimalBuilder builder(double d) {
        return new BigDecimalBuilder(d);
    }

    public BigDecimalBuilder add(String ... strs) {
        for (String str : strs) {
            this.set(this.bigDecimal.add(new BigDecimal(str)));
        }
        return this;
    }

    public BigDecimalBuilder add(double ... doubles) {
        for (double d : doubles) {
            this.set(this.bigDecimal.add(BigDecimal.valueOf(d)));
        }
        return this;
    }

    public BigDecimalBuilder add(int ... ints) {
        for (int i : ints) {
            this.set(this.bigDecimal.add(BigDecimal.valueOf(i)));
        }
        return this;
    }

    public BigDecimalBuilder sub(String ... strs) {
        for (String str : strs) {
            this.set(this.bigDecimal.subtract(new BigDecimal(str)));
        }
        return this;
    }

    public BigDecimalBuilder sub(double ... doubles) {
        for (double d : doubles) {
            this.set(this.bigDecimal.subtract(BigDecimal.valueOf(d)));
        }
        return this;
    }

    public BigDecimalBuilder sub(int ... ints) {
        for (int i : ints) {
            this.set(this.bigDecimal.subtract(BigDecimal.valueOf(i)));
        }
        return this;
    }

    public BigDecimalBuilder mul(String ... strs) {
        for (String str : strs) {
            this.set(this.bigDecimal.multiply(new BigDecimal(str)));
        }
        return this;
    }

    public BigDecimalBuilder mul(double ... doubles) {
        for (double d : doubles) {
            this.set(this.bigDecimal.multiply(BigDecimal.valueOf(d)));
        }
        return this;
    }

    public BigDecimalBuilder mul(int ... ints) {
        for (int i : ints) {
            this.set(this.bigDecimal.multiply(BigDecimal.valueOf(i)));
        }
        return this;
    }

    public BigDecimalBuilder div(String ... strs) {
        this.div(2, strs);
        return this;
    }

    public BigDecimalBuilder div(double ... doubles) {
        this.div(2, doubles);
        return this;
    }

    public BigDecimalBuilder div(int scale, String ... strs) {
        for (String str : strs) {
            this.set(this.bigDecimal.divide(new BigDecimal(str), scale, RoundingMode.HALF_UP));
        }
        return this;
    }

    public BigDecimalBuilder div(int scale, double ... doubles) {
        for (double d : doubles) {
            this.set(this.bigDecimal.divide(BigDecimal.valueOf(d), scale, RoundingMode.HALF_UP));
        }
        return this;
    }

    public BigDecimalBuilder div(int scale, int i) {
        this.set(this.bigDecimal.divide(BigDecimal.valueOf(i), scale, RoundingMode.HALF_UP));
        return this;
    }

    public BigDecimalBuilder round(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        this.set(this.bigDecimal.divide(BigDecimal.ONE, scale, RoundingMode.HALF_UP));
        return this;
    }

    public BigDecimalBuilder round() {
        this.round(2);
        return this;
    }

    public BigDecimal build() {
        return this.bigDecimal;
    }
}

