/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.util;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractI18nUtil {
    private Locale locale;
    protected String module = "";
    private String baseName = this.module + (this.module.length() > 0 ? "." : this.module) + "i18n.messages";
    private final List<Locale> supportLocale = List.of(Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.JAPANESE);

    public Locale getDefaultLocale() {
        String lang = System.getProperty("nl");
        if (lang != null) {
            switch (lang.toLowerCase()) {
                case "en": {
                    return Locale.ENGLISH;
                }
                case "zh": {
                    return Locale.SIMPLIFIED_CHINESE;
                }
                case "ja": {
                    return Locale.JAPANESE;
                }
            }
            return Locale.ENGLISH;
        }
        Locale locale = Locale.getDefault();
        if (this.supportLocale.contains(locale)) {
            return locale;
        }
        return Locale.ENGLISH;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (this.supportLocale.contains(locale)) {
            this.locale = locale;
        }
    }

    public void setLocale(String l) {
        switch (l.toLowerCase()) {
            case "en": {
                this.locale = Locale.ENGLISH;
                break;
            }
            case "zh": {
                this.locale = Locale.SIMPLIFIED_CHINESE;
                break;
            }
            case "ja": {
                this.locale = Locale.JAPANESE;
                break;
            }
        }
    }

    public String get(String key, Object ... args) {
        if (this.locale == null) {
            this.initLocale();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, this.getLocale());
        return MessageFormat.format(bundle.getString(key), args);
    }

    private void initLocale() {
        this.locale = this.getDefaultLocale();
        if (System.getProperty("nlurl") != null) {
            this.baseName = System.getProperty("nlurl");
        }
    }
}

