/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.interceptor;

import com.tlcsdm.common.base.BaseUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LogInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceId = request.getHeader(BaseUtils.TRACE_ID);
        if (traceId == null) {
            traceId = BaseUtils.getUuid();
        }
        MDC.put((String)BaseUtils.TRACE_ID, (String)traceId);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        MDC.remove((String)BaseUtils.TRACE_ID);
    }
}

