/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.config;

import com.tlcsdm.common.util.ThreadMdcUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class TraceThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(TraceThreadPoolTaskExecutor.class);

    private void showThreadPoolInfo(String prefix) {
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        log.info("{}, {},taskCount [{}], completedTaskCount [{}], activeCount [{}], queueSize [{}]", new Object[]{this.getThreadNamePrefix(), prefix, threadPoolExecutor.getTaskCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getActiveCount(), threadPoolExecutor.getQueue().size()});
    }

    public void execute(Runnable task) {
        this.showThreadPoolInfo("1. do execute");
        super.execute(ThreadMdcUtil.wrap(task, (Map<String, String>)MDC.getCopyOfContextMap()));
    }

    public Future<?> submit(Runnable task) {
        this.showThreadPoolInfo("1. do submit");
        return super.submit(ThreadMdcUtil.wrap(task, (Map<String, String>)MDC.getCopyOfContextMap()));
    }

    public <T> Future<T> submit(Callable<T> task) {
        this.showThreadPoolInfo("2. do submit");
        return super.submit(ThreadMdcUtil.wrap(task, (Map<String, String>)MDC.getCopyOfContextMap()));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        this.showThreadPoolInfo("1. do submitListenable");
        return super.submitListenable(task);
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        this.showThreadPoolInfo("2. do submitListenable");
        return super.submitListenable(task);
    }
}

