/*
 * Decompiled with CFR 0.152.
 */
package com.tlcsdm.common.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.util.StringUtils;

public class AbstractBaseUtils {
    protected static String DATA = "data";
    protected static String SUCCESS = "success";
    protected static String MESSAGE = "message";
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETARY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";

    public static String number2CNMonetaryUnit(BigDecimal numberOfMoney) {
        StringBuffer sb = new StringBuffer();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, RoundingMode.HALF_UP).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETARY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETARY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETARY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    sb.insert(0, CN_UPPER_MONETARY_UNIT[numIndex]);
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETARY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public static String getMd5(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(string.getBytes());
            byte[] hash = md.digest();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (int offset = 0; offset < hash.length; ++offset) {
                i = hash[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(i));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFormatString(HttpServletRequest request, String s) throws UnsupportedEncodingException {
        String filename = s;
        String userAgent = request.getHeader("User-Agent").toUpperCase();
        if (userAgent.indexOf("FIREFOX") > 0) {
            filename = new String(s.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        } else if (userAgent.indexOf("MSIE") > 0) {
            filename = URLEncoder.encode(s, "UTF-8");
        } else if (userAgent.indexOf("CHROME") > 0) {
            filename = new String(s.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(InputStream inputStream, String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        fileName = AbstractBaseUtils.getFormatString(request, fileName);
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        ServletOutputStream out = response.getOutputStream();
        try {
            byte[] content = new byte[65535];
            int length = 0;
            while ((length = inputStream.read(content)) != -1) {
                out.write(content, 0, length);
                out.flush();
            }
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }

    public static byte[] inputStreamToBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] content = new byte[65535];
        int length = 0;
        while ((length = inputStream.read(content)) != -1) {
            baos.write(content, 0, length);
        }
        return baos.toByteArray();
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] content = new byte[65535];
        int length = 0;
        while ((length = inputStream.read(content)) != -1) {
            baos.write(content, 0, length);
        }
        return baos.toString();
    }

    public static String fillWithZero(String str) {
        if (str != null && str.length() < 2) {
            return "0" + str;
        }
        return str;
    }

    public static String getUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static Map<String, Object> loadSuccess(Map<String, Object> result) {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put(DATA, result);
        return AbstractBaseUtils.success(data);
    }

    public static Map<String, Object> saveSuccess(String id) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(SUCCESS, true);
        result.put(DATA, id);
        return result;
    }

    public static Map<String, Object> success(Map<String, Object> result) {
        result.put(SUCCESS, true);
        return result;
    }

    public static <T> Map<String, Object> success(List<T> list) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(SUCCESS, true);
        result.put(DATA, list);
        return result;
    }

    public static <T> Map<String, Object> success(List<T> list, int total) {
        Map<String, Object> result = AbstractBaseUtils.success(list);
        result.put("total", total);
        return result;
    }

    public static <T> Map<String, Object> success(List<T> list, long total) {
        Map<String, Object> result = AbstractBaseUtils.success(list);
        result.put("total", total);
        return result;
    }

    public static Map<String, Object> success() {
        return Collections.singletonMap(SUCCESS, true);
    }

    public static Map<String, Object> failed(String message) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(SUCCESS, false);
        result.put(MESSAGE, message);
        return result;
    }

    public static Map<String, Object> failed(Map<String, Object> result, String message) {
        result.put(SUCCESS, false);
        result.put(MESSAGE, message);
        return result;
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-FORWARDED-FOR");
        if (!StringUtils.hasLength((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (!StringUtils.hasLength((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (!StringUtils.hasLength((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (!StringUtils.hasLength((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (!StringUtils.hasLength((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            return "127.0.0.1";
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static String getUrl(HttpServletRequest request) {
        String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath();
        if (request.getQueryString() != null) {
            url = url + "?" + request.getQueryString();
        }
        return url;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "\u672a\u77e5";
        }
    }

    public static String getCookieValue(String key, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return "";
    }

    public static <T> List<T> page(List<T> list, Integer page, Integer limit) {
        return page != null && limit != null && page > 0 && limit > 0 ? list.stream().skip(limit * (page - 1)).limit(limit.intValue()).collect(Collectors.toList()) : list;
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static String toLowerCase4Index(String string) {
        if (Character.isLowerCase(string.charAt(0))) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[0] = (char)(chars[0] + 32);
        return String.valueOf(chars);
    }

    public static String toUpperCase4Index(String string) {
        char[] chars = string.toCharArray();
        chars[0] = AbstractBaseUtils.toUpperCase(chars[0]);
        return String.valueOf(chars);
    }

    public static char toUpperCase(char chars) {
        if ('a' <= chars && chars <= 'z') {
            chars = (char)(chars ^ 0x20);
        }
        return chars;
    }

    public static int newHashMapWithExpectedSize(int expectedSize) {
        if (expectedSize < 3) {
            return 4;
        }
        return expectedSize < 0x40000000 ? (int)((float)expectedSize / 0.75f + 1.0f) : Integer.MAX_VALUE;
    }

    public static Object deepClone(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            if (object != null) {
                objectOutputStream.writeObject(object);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return objectInputStream.readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void dealCommonExcel(HSSFWorkbook wb, HSSFSheet sheet, List<Map<String, Object>> list, LinkedHashMap<String, String> map) {
        int length = map.size() + 1;
        ArrayList keyList = new ArrayList(length);
        ArrayList valueList = new ArrayList(length);
        map.forEach((key, value) -> {
            keyList.add(key);
            valueList.add(value);
        });
        for (int i = 0; i < length; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 2);
        }
        HSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        font.setFontHeightInPoints((short)12);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        HSSFCell cell0 = row.createCell(0);
        cell0.setCellValue("\u5e8f\u53f7");
        cell0.setCellStyle(style);
        for (int i = 1; i < length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue((String)keyList.get(i - 1));
            cell.setCellStyle(style);
        }
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setWrapText(true);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        for (int i = 0; i < list.size(); ++i) {
            row = sheet.createRow(i + 1);
            row.setHeightInPoints(25.0f);
            HSSFCell cellContent = row.createCell(0);
            cellContent.setCellValue((double)(i + 1));
            cellContent.setCellStyle(cellStyle);
            for (int j = 1; j < length; ++j) {
                cellContent = row.createCell(j);
                cellContent.setCellValue(AbstractBaseUtils.valueOf(list.get(i).get(valueList.get(j - 1))));
                cellContent.setCellStyle(cellStyle);
            }
        }
    }

    public static String valueOf(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static void download(Workbook wb, String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        fileName = AbstractBaseUtils.getFormatString(request, fileName);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        ServletOutputStream os = response.getOutputStream();
        wb.write((OutputStream)os);
        os.flush();
        os.close();
    }

    public static Date addOneDay(Date date) {
        if (date == null) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        return c.getTime();
    }

    public static Timestamp strToSqlDate(String strDate, String dateFormat) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = simpleDateFormat.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp dateToTime(Date date) {
        String strDate = AbstractBaseUtils.dateToStr(date, "yyyy-MM-dd HH:mm:ss SSS");
        return AbstractBaseUtils.strToSqlDate(strDate, "yyyy-MM-dd HH:mm:ss SSS");
    }

    public static String dateToStr(Date date, String strFormat) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(strFormat);
        return simpleDateFormat.format(date);
    }

    public static String getCellValue(Cell cell) {
        String result;
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
                    Date date = cell.getDateCellValue();
                    result = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == 58) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    double value = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)value);
                    result = sdf.format(date);
                    break;
                }
                double value = cell.getNumericCellValue();
                CellStyle style = cell.getCellStyle();
                DecimalFormat format = new DecimalFormat();
                String temp = style.getDataFormatString();
                if ("General".equals(temp)) {
                    format.applyPattern("#.####");
                }
                result = format.format(value);
                break;
            }
            case STRING: {
                result = cell.getRichStringCellValue().toString();
                break;
            }
            case BLANK: {
                result = "";
                break;
            }
            case FORMULA: {
                result = String.valueOf(cell.getNumericCellValue());
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callbackNotFound(HttpServletResponse response, Exception e) {
        e.printStackTrace();
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = null;
        try {
            try {
                out = response.getWriter();
                out.print("<span style=\"display:block;text-align: center;margin:0 auto;min-width: 150px;\">" + e.getMessage() + "</span><br/>");
                out.print("<br/><button autocomplete=\"off\" onclick=\"javascript:window.history.back(-1);return false;\" autofocus=\"true\"\n            style=\"display:block;margin:0 auto;min-width: 150px;background-color:rgb(0, 138, 203);color: rgb(255, 255, 255);\">\n        \u8fd4\u56de\u4e0a\u4e00\u4e2a\u9875\u9762\n    </button>");
                out.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            if (Collections.singletonList(out).get(0) != null) {
                out.close();
            }
        }
    }
}

