/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineProcessException;
import com.tibco.bw.maven.plugin.test.setuplocal.OSGICommandExecutor;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class EngineRunner {
    private int engineStartupWaitTime = 2;
    private List<String> osgiCommands = new ArrayList<String>();
    CountDownLatch latch = new CountDownLatch(1);
    AtomicBoolean isEngineStarted = new AtomicBoolean(false);
    AtomicBoolean isImpaired = new AtomicBoolean(false);

    public EngineRunner(int engineStartupWaitTime, List<String> osgiCommands) {
        this.engineStartupWaitTime = engineStartupWaitTime;
        this.osgiCommands = osgiCommands;
    }

    public void run() throws Exception {
        Process process = null;
        ProcessBuilder builder = new ProcessBuilder(BWTestConfig.INSTANCE.getLaunchConfig());
        process = builder.start();
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"## Starting BW Engine in Test Mode ##");
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"----------------------BW Engine Logs Start------------------------------");
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"");
        BWTestConfig.INSTANCE.setEngineProcess(process);
        Runnable input = this.getInputRunnable(process);
        Runnable error = this.getErrorRunnable(process);
        Thread inputThread = new Thread(input);
        Thread errorThread = new Thread(error);
        inputThread.start();
        errorThread.start();
        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Engine Startup wait time -> " + this.engineStartupWaitTime + " mins"));
        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("OSGi Commands -> " + this.osgiCommands));
        this.latch.await(this.engineStartupWaitTime, TimeUnit.MINUTES);
        OSGICommandExecutor cmdExecutor = new OSGICommandExecutor();
        for (String command : this.osgiCommands) {
            BWTestConfig.INSTANCE.getLogger().info((CharSequence)"------------------------------------------------------------------------");
            BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## Executing OSGi command (" + command + ") ##"));
            BWTestConfig.INSTANCE.getLogger().info((CharSequence)"------------------------------------------------------------------------");
            cmdExecutor.executeCommand(command);
        }
        if (this.isImpaired.get() && !this.isEngineStarted.get()) {
            String command = "la";
            if (this.osgiCommands.isEmpty()) {
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)"------------------------------------------------------------------------");
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## Executing OSGi command (" + command + ") ##"));
                BWTestConfig.INSTANCE.getLogger().info((CharSequence)"------------------------------------------------------------------------");
                cmdExecutor.executeCommand(command);
            }
        }
        if (!this.isEngineStarted.get()) {
            throw new EngineProcessException("Failed to start BW Engine. Please see logs for more details");
        }
        BWTestConfig.INSTANCE.getLogger().info((CharSequence)"## BW Engine Successfully Started ##");
    }

    private Runnable getErrorRunnable(final Process process) {
        Runnable error = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        BWTestConfig.INSTANCE.getLogger().error((CharSequence)line);
                    }
                }
                catch (Exception e) {
                    BWTestConfig.INSTANCE.getLogger().error((Throwable)e);
                }
            }
        };
        return error;
    }

    private Runnable getInputRunnable(final Process process) {
        Runnable input = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        BWTestConfig.INSTANCE.getLogger().info((CharSequence)line);
                        if (line.contains("TIBCO-THOR-FRWK-300006") && line.contains("Started BW Application")) {
                            EngineRunner.this.isEngineStarted.set(true);
                            EngineRunner.this.latch.countDown();
                        }
                        if (!line.contains("TIBCO-THOR-FRWK-300019") || !line.contains("impaired")) continue;
                        EngineRunner.this.isImpaired.set(true);
                    }
                    if (EngineRunner.this.latch.getCount() > 0L) {
                        EngineRunner.this.isEngineStarted.set(false);
                        EngineRunner.this.latch.countDown();
                    }
                }
                catch (Exception e) {
                    BWTestConfig.INSTANCE.getLogger().error((Throwable)e);
                }
            }
        };
        return input;
    }
}

