/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.osgi.helpers.ManifestParser;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.utils.Path;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public class ConfigFileGenerator {
    ArrayList<String> bundleNamesList = new ArrayList();
    Boolean isBundleToStart = false;

    public void generateConfig() {
        try {
            File configIni = new File(BWTestConfig.INSTANCE.getConfigDir(), "config.ini");
            configIni.createNewFile();
            StringBuilder builder = new StringBuilder();
            List<File> targets = this.getTargetPlatform();
            for (File target : targets) {
                this.addPluginsFromDir(target, builder);
            }
            ArrayList<MavenProject> cxfProjects = new ArrayList<MavenProject>();
            List projects = BWTestConfig.INSTANCE.getSession().getProjects();
            for (MavenProject project : projects) {
                Set artifacts;
                if (!project.getPackaging().equals("bwmodule") && !project.getPackaging().equals("bwear") || (artifacts = project.getDependencyArtifacts()) == null) continue;
                boolean isCXF = false;
                for (Artifact artifact : artifacts) {
                    if (!("provided".equals(artifact.getScope()) || artifact.getFile().getName().contains("com.tibco.bw.palette.shared") || artifact.getFile().getName().contains("com.tibco.xml.cxf.common") || artifact.getGroupId().equalsIgnoreCase("tempbw"))) {
                        builder.append(",");
                        this.addReference(builder, artifact.getFile(), artifact.getArtifactId());
                    }
                    if (!artifact.getFile().getName().contains("com.tibco.xml.cxf.common")) continue;
                    isCXF = true;
                }
                if (!isCXF) continue;
                cxfProjects.add(project);
            }
            for (MavenProject project : projects) {
                if (!project.getPackaging().equals("bwmodule") && !project.getPackaging().equals("bwear")) continue;
                builder.append(",");
                this.addReference(builder, project.getBasedir(), project.getBasedir().getName());
            }
            Properties properties = new Properties();
            properties.put("osgi.bundles", builder.toString());
            properties.put("osgi.bundles.defaultStartLevel", "5");
            properties.put("osgi.install.area", "file:" + BWTestConfig.INSTANCE.getTibcoHome() + BWTestConfig.INSTANCE.getBwHome() + "/system/hotfix/lib/common");
            properties.put("osgi.framework", "file:" + BWTestConfig.INSTANCE.getTibcoHome() + BWTestConfig.INSTANCE.getBwHome() + "/system/lib/common/org.eclipse.osgi_3.15.300.v20200520-1959.jar");
            properties.put("osgi.configuration.cascaded", "false");
            FileOutputStream stream = new FileOutputStream(configIni);
            properties.store(stream, "Configuration File");
            stream.flush();
            stream.close();
            this.generateDevPropertiesFile(cxfProjects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateDevPropertiesFile(List<MavenProject> cxfProjects) throws IOException, DependencyResolutionRequiredException {
        File devProps = new File(BWTestConfig.INSTANCE.getConfigDir(), "dev.properties");
        devProps.createNewFile();
        Properties properties = new Properties();
        properties.put("@ignoredot@", "true");
        for (MavenProject cxfProject : cxfProjects) {
            Manifest projectManifest = ManifestParser.parseManifest(cxfProject.getBasedir());
            String bundleClassPath = projectManifest.getMainAttributes().getValue("Bundle-ClassPath");
            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Bundle-Classpath for project " + cxfProject.getName() + " -> " + bundleClassPath));
            Object pathString = "";
            if (bundleClassPath != null) {
                String[] pathEntries;
                for (String path : pathEntries = bundleClassPath.split(",")) {
                    if (path.equals(".")) continue;
                    pathString = (String)pathString + "," + path;
                }
            }
            pathString = "bin,target/classes" + (String)pathString;
            properties.put(cxfProject.getName(), pathString);
            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Adding CXF project entry to dev.properties -> " + cxfProject.getName() + "=" + (String)pathString));
        }
        FileOutputStream stream = new FileOutputStream(devProps);
        properties.store(stream, "dev properties");
        stream.flush();
        stream.close();
    }

    private void addPluginsFromDir(File target, StringBuilder builder) {
        File[] files;
        for (File file : files = target.listFiles()) {
            File libFolder = new File(file.getAbsolutePath().concat("/lib"));
            if (libFolder.exists() && libFolder.isDirectory() && libFolder.list().length == 0 || file.getName().contains("DS_Store")) continue;
            String[] split = file.getName().split("_");
            if (this.bundleNamesList.isEmpty()) {
                this.bundleNamesList.add(split[0]);
                this.isBundleToStart = true;
            } else {
                for (String bundleName : this.bundleNamesList) {
                    if (null != bundleName && bundleName.equals(split[0])) {
                        this.isBundleToStart = false;
                        break;
                    }
                    this.isBundleToStart = true;
                }
                if (this.isBundleToStart.booleanValue()) {
                    this.bundleNamesList.add(split[0]);
                }
            }
            if (!this.isBundleToStart.booleanValue()) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            this.addReference(builder, file, split[0]);
        }
    }

    private void addReference(StringBuilder builder, File file, String key) {
        builder.append("reference:");
        builder.append("file:");
        builder.append(new Path(file.getAbsolutePath()).removeTrailingSeparator().toString());
        builder.append(this.getStartValue(key));
    }

    private List<File> getTargetPlatform() {
        File file;
        ArrayList<File> list = new ArrayList<File>();
        String[] platformDirs = new String[]{"system/hotfix/lib/common", "system/lib/common", "system/hotfix/palettes", "system/palettes", "system/hotfix/shared", "system/shared", "config/drivers/shells/jdbc.oracle.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.oracle.runtime/runtime/plugins", "config/drivers/shells/jdbc.mysql.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.mysql.runtime/runtime/plugins", "config/drivers/shells/jdbc.mariadb.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.mariadb.runtime/runtime/plugins", "config/drivers/shells/jdbc.db2.runtime/hotfix/runtime/plugins", "config/drivers/shells/jdbc.db2.runtime/runtime/plugins"};
        String bwHomeStr = BWTestConfig.INSTANCE.getTibcoHome() + BWTestConfig.INSTANCE.getBwHome();
        File pluginPalettes = BWTestConfig.INSTANCE.getBwHome().contains("bwce") ? new File(BWTestConfig.INSTANCE.getTibcoHome().concat("/bwce/palettes")) : new File(BWTestConfig.INSTANCE.getTibcoHome().concat("/bw/palettes"));
        if (pluginPalettes.exists() && pluginPalettes.isDirectory()) {
            java.nio.file.Path[] pluginPlatformDirs = this.getPluginPlatformDir(pluginPalettes.getPath());
            for (java.nio.file.Path pluginFile : pluginPlatformDirs) {
                file = new File(pluginFile.toString(), "plugins");
                if (!file.exists()) continue;
                list.add(file);
            }
        }
        File bwHome = new File(bwHomeStr);
        for (String str : platformDirs) {
            file = new File(bwHome, str);
            if (!file.exists()) continue;
            list.add(file);
        }
        return list;
    }

    private java.nio.file.Path[] getPluginPlatformDir(String path) {
        java.nio.file.Path[] pathArray;
        block8: {
            Stream<java.nio.file.Path> paths = Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);
            try {
                java.nio.file.Path[] pluginDirPath;
                pathArray = pluginDirPath = (java.nio.file.Path[])paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(s -> s.endsWith("runtime")).toArray(java.nio.file.Path[]::new);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            paths.close();
        }
        return pathArray;
    }

    private Map<String, String> getStartValuesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.tibco.tpcl.javax.system.exports", "");
        map.put("com.tibco.bw.extensions.logback", "");
        map.put("com.tibco.bw.thor.equinox.env", "");
        map.put("com.tibco.neo.eclipse.support.osgi", "@3:start");
        map.put("org.eclipse.osgi.compatibility.state", "");
        map.put("com.tibco.bw.thor.runtime.tools", "@2:start");
        map.put("com.tibco.tpcl.javax.osgi.factories", "@1:start");
        map.put("org.eclipse.equinox.common", "@2:start");
        map.put("com.tibco.tpcl.javax.system.exports.sun", "");
        map.put("org.eclipse.equinox.console.jaas.fragment", "");
        return map;
    }

    private String getStartValue(String key) {
        Map<String, String> map = this.getStartValuesMap();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "@start";
    }
}

