/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.report;

import com.tibco.bw.maven.plugin.test.coverage.ProcessCoverage;
import com.tibco.bw.maven.plugin.test.coverage.ProcessCoverageParser;
import com.tibco.bw.maven.plugin.test.coverage.ProcessCoverageStatsGenerator;
import com.tibco.bw.maven.plugin.test.dto.CompleteReportDTO;
import com.tibco.bw.maven.plugin.test.report.BWTestSuiteReportParser;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;

public class CodeCoverageReportGenerator {
    private static final int LEFT = 1;
    private static final Object[] TAG_TYPE_START = new Object[]{2};
    private static final Object[] TAG_TYPE_END = new Object[]{3};
    private CompleteReportDTO result;
    private BWTestSuiteReportParser bwTestParser;

    public void generateReport(CompleteReportDTO result, Sink sink) {
        ProcessCoverageParser parser = new ProcessCoverageParser();
        Map<String, ProcessCoverage> map = parser.loadCoverage(result);
        ProcessCoverageStatsGenerator gen = new ProcessCoverageStatsGenerator();
        gen.generateStats(map);
        ProcessCoverageStatsGenerator.OverAllStats comStats = gen.getStats();
        List<ProcessCoverageStatsGenerator.ProcessStats> stats = gen.getProcessStats();
        sink.head();
        sink.title();
        sink.text("BW Coverage");
        sink.title_();
        sink.head_();
        sink.body();
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute((Object)"type", (Object)"text/javascript");
        sink.unknown("script", new Object[]{2}, (SinkEventAttributes)atts);
        sink.unknown("cdata", new Object[]{5, CodeCoverageReportGenerator.javascriptToggleDisplayCode()}, null);
        sink.unknown("script", new Object[]{3}, null);
        sink.section1();
        sink.sectionTitle1();
        sink.text("BW Coverage Report");
        sink.sectionTitle1_();
        sink.section1_();
        this.constructSummarySection(sink, comStats);
        this.constructProcessSection(sink, stats);
    }

    private void constructSummarySection(Sink sink, ProcessCoverageStatsGenerator.OverAllStats stats) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Summary");
        sink.sectionTitle1_();
        CodeCoverageReportGenerator.sinkAnchor(sink, "Overall Coverage Summary");
        CodeCoverageReportGenerator.sinkLineBreak(sink);
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1}, true);
        sink.tableRow();
        CodeCoverageReportGenerator.sinkHeader(sink, "Modules %");
        CodeCoverageReportGenerator.sinkHeader(sink, "Process %");
        CodeCoverageReportGenerator.sinkHeader(sink, "Activity %");
        CodeCoverageReportGenerator.sinkHeader(sink, "Transition %");
        sink.tableRow_();
        sink.tableRow();
        CodeCoverageReportGenerator.sinkCell(sink, stats.getModuleStat());
        CodeCoverageReportGenerator.sinkCell(sink, stats.getProcessStat());
        CodeCoverageReportGenerator.sinkCell(sink, stats.getActivityStat());
        CodeCoverageReportGenerator.sinkCell(sink, stats.getTransitionStat());
        sink.tableRow_();
        sink.tableRows_();
        sink.table_();
        CodeCoverageReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private void constructProcessSection(Sink sink, List<ProcessCoverageStatsGenerator.ProcessStats> stats) {
        sink.section1();
        sink.sectionTitle1();
        sink.text("Coverage BreakDown By Process");
        sink.sectionTitle1_();
        sink.table();
        sink.tableRows(new int[]{1, 1, 1, 1}, true);
        sink.tableRow();
        CodeCoverageReportGenerator.sinkHeader(sink, "Module");
        CodeCoverageReportGenerator.sinkHeader(sink, "Process");
        CodeCoverageReportGenerator.sinkHeader(sink, "Activity Name");
        CodeCoverageReportGenerator.sinkHeader(sink, "Activity %");
        CodeCoverageReportGenerator.sinkHeader(sink, "Transition %");
        sink.tableRow_();
        for (ProcessCoverageStatsGenerator.ProcessStats stat : stats) {
            sink.tableRow();
            CodeCoverageReportGenerator.sinkCell(sink, stat.getModuleName());
            CodeCoverageReportGenerator.sinkCell(sink, stat.getProcessName());
            CodeCoverageReportGenerator.sinkCell(sink, stat.getCoveredActivitiesName().toString());
            CodeCoverageReportGenerator.sinkCell(sink, stat.getActivityStat());
            CodeCoverageReportGenerator.sinkCell(sink, stat.getTransitionStat());
            sink.tableRow_();
        }
        sink.tableRows_();
        sink.table_();
        CodeCoverageReportGenerator.sinkLineBreak(sink);
        sink.section1_();
    }

    private static void sinkLineBreak(Sink sink) {
        sink.lineBreak();
    }

    private static void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private static void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private static void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private static void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        CodeCoverageReportGenerator.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private static void sinkCellAnchor(Sink sink, String text, String anchor) {
        sink.tableCell();
        CodeCoverageReportGenerator.sinkAnchor(sink, anchor);
        sink.text(text);
        sink.tableCell_();
    }

    private static void sinkAnchor(Sink sink, String anchor) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"name", anchor}));
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private static void sinkLink(Sink sink, String href) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_START, (SinkEventAttributes)new SinkEventAttributeSet(new String[]{"href", href}));
    }

    private static void sinkLink_(Sink sink) {
        sink.unknown(HtmlMarkup.A.toString(), TAG_TYPE_END, null);
    }

    private static String javascriptToggleDisplayCode() {
        return "\nfunction toggleDisplay(elementId) {\n var elm = document.getElementById(elementId + '-error');\n if (elm == null) {\n  elm = document.getElementById(elementId + '-failure');\n }\n if (elm && typeof elm.style != \"undefined\") {\n  if (elm.style.display == \"none\") {\n   elm.style.display = \"\";\n   document.getElementById(elementId + '-off').style.display = \"none\";\n   document.getElementById(elementId + '-on').style.display = \"inline\";\n  } else if (elm.style.display == \"\") {   elm.style.display = \"none\";\n   document.getElementById(elementId + '-off').style.display = \"inline\";\n   document.getElementById(elementId + '-on').style.display = \"none\";\n  } \n } \n }\n//";
    }
}

