/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.helpers;

import com.tibco.bw.maven.plugin.test.dto.AssertionDTO;
import com.tibco.bw.maven.plugin.test.dto.ConditionLanguageDTO;
import com.tibco.bw.maven.plugin.test.dto.MockActivityDTO;
import com.tibco.bw.maven.plugin.test.dto.TestCaseDTO;
import com.tibco.bw.maven.plugin.test.dto.TestSetDTO;
import com.tibco.bw.maven.plugin.test.dto.TestSuiteDTO;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestFileParser {
    public static TestFileParser INSTANCE = new TestFileParser();
    boolean disableMocking = false;
    boolean disableAssertions = false;
    boolean showFailureDetails = false;

    private TestFileParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAssertions(String contents, TestSuiteDTO suite, String baseDirectoryPath) throws Exception, FileNotFoundException {
        String assertionMode = "Primitive";
        InputStream is = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            Document document = builder.parse(is);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            String testCaseFile = document.getDocumentElement().getAttribute("location");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"ProcessNode".equals((el = (Element)node).getNodeName())) continue;
                String componentName = null;
                suite.setShowFailureDetails(this.showFailureDetails);
                String processId = el.getAttributes().getNamedItem("Id").getNodeValue();
                String processName = el.getAttributes().getNamedItem("Name").getNodeValue();
                String moduleName = el.getAttributes().getNamedItem("moduleName").getNodeValue();
                if (null != el.getAttributes().getNamedItem("componentProcessName")) {
                    componentName = el.getAttributes().getNamedItem("componentProcessName").getNodeValue();
                }
                if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
                    BWTestConfig.INSTANCE.getTestCaseWithProcessNameMap().put(testCaseFile, processId);
                }
                String packageName = BWFileUtils.getFileNameWithoutExtn(processId);
                TestSetDTO testset = this.getProcessTestSet(processId, suite);
                testset.setPackageName(packageName);
                testset.setComponentName(componentName);
                TestCaseDTO testcase = new TestCaseDTO();
                testcase.setTestCaseFile(testCaseFile);
                NodeList childNodes = el.getChildNodes();
                block29: for (int j = 0; j < childNodes.getLength(); ++j) {
                    Element input;
                    NodeList operationNodes;
                    String inputValue;
                    File file;
                    String inputFilePath;
                    Node gcNode;
                    NodeList gChildNodes;
                    String location;
                    Node cNode = childNodes.item(j);
                    if (!(cNode instanceof Element)) continue;
                    Element cEl = (Element)cNode;
                    if ("Assertion".equals(cEl.getNodeName())) {
                        if (this.disableAssertions) continue;
                        assertionMode = null != cEl.getAttributes().getNamedItem("goldOutputFromFile") && "true".equals(cEl.getAttributes().getNamedItem("goldOutputFromFile").getNodeValue()) ? "ActivityWithGoldFile" : (null != cEl.getAttributes().getNamedItem("assertionType") && "Activity".equals(cEl.getAttributes().getNamedItem("assertionType").getNodeValue()) ? "Activity" : "Primitive");
                        AssertionDTO ast = new AssertionDTO();
                        ast.setProcessId(processId);
                        ast.setAssertionMode(assertionMode);
                        location = cEl.getAttributes().getNamedItem("Id").getNodeValue();
                        String activityName = cEl.getAttributes().getNamedItem("Name").getNodeValue();
                        ast.setActivityId(activityName);
                        ast.setLocation(location);
                        gChildNodes = cEl.getChildNodes();
                        block30: for (int k = 0; k < gChildNodes.getLength(); ++k) {
                            gcNode = gChildNodes.item(k);
                            if (!(gcNode instanceof Element)) continue;
                            Element gcEl = (Element)gcNode;
                            switch (gcEl.getNodeName()) {
                                case "Lang": {
                                    String conditionLanguage = gcEl.getLastChild().getTextContent();
                                    if ("urn:oasis:names:tc:wsbpel:2.0:sublang:xslt1.0".equals(conditionLanguage)) {
                                        ast.setConditionLanguage(ConditionLanguageDTO.XSLT10);
                                        continue block30;
                                    }
                                    ast.setConditionLanguage(ConditionLanguageDTO.XSLT20);
                                    continue block30;
                                }
                                case "Expression": {
                                    String expression = null;
                                    if (gcEl.getLastChild() == null) {
                                        throw new Exception("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Activity Assertion Configuration.");
                                    }
                                    expression = gcEl.getLastChild().getTextContent();
                                    String replaceInputFile = null;
                                    String inputFile = null;
                                    if ("ActivityWithGoldFile".equals(assertionMode)) {
                                        inputFile = StringUtils.substringBetween((String)expression, (String)"file:///", (String)"')");
                                        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Expression - " + expression));
                                        if (inputFile == null) {
                                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Gold File Path. Valid example is - doc('file:///<path-to-file>')"));
                                            throw new Exception("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Gold File Path. Valid example is - doc('file:///<path-to-file>')");
                                        }
                                        File goldInputFile = new File(inputFile);
                                        if (!goldInputFile.isAbsolute()) {
                                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Provided Gold File path is relative " + inputFile));
                                            baseDirectoryPath = baseDirectoryPath.replace("\\", "/");
                                            replaceInputFile = baseDirectoryPath.concat("/" + inputFile);
                                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Absolute File path " + replaceInputFile));
                                            expression = StringUtils.replace((String)expression, (String)inputFile, (String)replaceInputFile);
                                        }
                                        if (null != replaceInputFile) {
                                            inputFile = replaceInputFile;
                                        }
                                    }
                                    if (this.showFailureDetails) {
                                        this.setGoldData(assertionMode, expression, ast, inputFile);
                                    }
                                    ast.setExpression(expression);
                                }
                            }
                        }
                        testcase.getAssertionList().add(ast);
                        continue;
                    }
                    if ("Operation".equals(cEl.getNodeName())) {
                        boolean isInputFile = false;
                        if (null != cEl.getAttribute("Name")) {
                            testcase.setOperationName(cEl.getAttribute("Name"));
                        }
                        if (null != cEl.getAttribute("serviceName")) {
                            testcase.setServiceName(cEl.getAttribute("serviceName"));
                        }
                        testcase.setServiceType(cEl.getAttribute("restOperationName"));
                        NodeList inputNodes = cEl.getElementsByTagName("Inputs");
                        if (inputNodes != null && inputNodes.getLength() > 0) {
                            Element input2 = (Element)inputNodes.item(0);
                            String location2 = input2.getAttribute("Id");
                            String ID = StringUtils.substringBefore((String)location2, (String)moduleName);
                            testcase.setProcessStarterID(ID);
                            if (input2.hasAttribute("isInputFile") && "true".equals(input2.getAttribute("isInputFile"))) {
                                isInputFile = true;
                                if (input2.hasAttribute("inputFile")) {
                                    BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Reading start activity input from file -> " + input2.getAttribute("inputFile")));
                                    inputFilePath = input2.getAttribute("inputFile");
                                    if (inputFilePath == null || inputFilePath.isEmpty()) {
                                        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : Start , Error : Invalid Start Input File Path - " + inputFilePath));
                                        throw new Exception("Process : " + processName + ", Activity : Start, Error : Invalid Start Input File Path - " + inputFilePath);
                                    }
                                    file = new File(inputFilePath);
                                    if (!file.isAbsolute()) {
                                        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Provided Start Input File path is relative -> " + file.getPath()));
                                        inputFilePath = baseDirectoryPath.concat("/" + inputFilePath);
                                    }
                                    inputValue = FileUtils.readFileToString((File)new File(inputFilePath));
                                    testcase.setXmlInput(inputValue);
                                } else {
                                    BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : Start , Error : Invalid Start Input File Path - " + input2.getAttribute("InputFile")));
                                    throw new Exception("Process : " + processName + ", Activity : Start, Error : Invalid Start Input File Path - " + input2.getAttribute("InputFile"));
                                }
                            }
                        }
                        if (isInputFile) continue;
                        NodeList gChildNodes2 = cEl.getChildNodes();
                        for (int k = 0; k < gChildNodes2.getLength(); ++k) {
                            Element e1;
                            Node gcNode2 = gChildNodes2.item(k);
                            if (!(gcNode2 instanceof Element) || !"resolvedInput".equals((e1 = (Element)gcNode2).getNodeName())) continue;
                            String inputValue2 = e1.getAttribute("inputValue");
                            testcase.setXmlInput(inputValue2);
                            continue block29;
                        }
                        continue;
                    }
                    if ("MockActivity".equals(cEl.getNodeName()) || "MockFault".equals(cEl.getNodeName())) {
                        MockActivityDTO mockActivity = new MockActivityDTO();
                        location = cEl.getAttributes().getNamedItem("Id").getNodeValue();
                        String activityName = cEl.getAttributes().getNamedItem("Name").getNodeValue();
                        mockActivity.setLocation(location);
                        gChildNodes = cEl.getChildNodes();
                        for (int k = 0; k < gChildNodes.getLength(); ++k) {
                            boolean isValidFile;
                            Element e1;
                            gcNode = gChildNodes.item(k);
                            if (!(gcNode instanceof Element) || !"MockOutputFilePath".equals((e1 = (Element)gcNode).getNodeName())) continue;
                            String mockOutputFilePath = e1.getTextContent();
                            if (mockOutputFilePath == null || mockOutputFilePath.trim().length() == 0) {
                                BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Mock Output File Path - " + mockOutputFilePath));
                                throw new Exception("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Mock Output File Path - " + mockOutputFilePath);
                            }
                            File file2 = new File(mockOutputFilePath);
                            if (!file2.isAbsolute()) {
                                BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Provided Mock File path is relative " + file2.getPath()));
                                mockOutputFilePath = baseDirectoryPath.concat("/" + mockOutputFilePath);
                            }
                            if (this.disableMocking || !(isValidFile = this.validateMockXMLFile(mockOutputFilePath, activityName, processName))) continue;
                            mockActivity.setmockOutputFilePath(mockOutputFilePath);
                            testcase.setmockOutputFilePath(mockOutputFilePath);
                            testcase.getMockActivityList().add(mockActivity);
                            continue block29;
                        }
                        continue;
                    }
                    if (!"restNode".equals(cEl.getNodeName()) || (operationNodes = cEl.getElementsByTagName("Operation")) == null || operationNodes.getLength() <= 0) continue;
                    Element operation = (Element)operationNodes.item(0);
                    boolean isInputFile = false;
                    if (null != operation.getAttribute("Name")) {
                        testcase.setOperationName(operation.getAttribute("Name"));
                    }
                    if (null != operation.getAttribute("serviceName")) {
                        testcase.setServiceName(operation.getAttribute("serviceName"));
                    }
                    testcase.setServiceType(operation.getAttribute("restOperationName"));
                    NodeList inputNodes = operation.getElementsByTagName("Inputs");
                    if (inputNodes == null || inputNodes.getLength() <= 0 || !(input = (Element)inputNodes.item(0)).hasAttribute("isInputFile") || !"true".equals(input.getAttribute("isInputFile"))) continue;
                    isInputFile = true;
                    if (input.hasAttribute("inputFile")) {
                        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Reading start activity input from file -> " + input.getAttribute("inputFile")));
                        inputFilePath = input.getAttribute("inputFile");
                        if (inputFilePath == null || inputFilePath.isEmpty()) {
                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : Start , Error : Invalid Start Input File Path - " + inputFilePath));
                            throw new Exception("Process : " + processName + ", Activity : Start, Error : Invalid Start Input File Path - " + inputFilePath);
                        }
                        file = new File(inputFilePath);
                        if (!file.isAbsolute()) {
                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Provided Start Input File path is relative -> " + file.getPath()));
                            inputFilePath = baseDirectoryPath.concat("/" + inputFilePath);
                        }
                        inputValue = FileUtils.readFileToString((File)new File(inputFilePath));
                        testcase.setXmlInput(inputValue);
                        continue;
                    }
                    BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : Start , Error : Invalid Start Input File Path - " + input.getAttribute("InputFile")));
                    throw new Exception("Process : " + processName + ", Activity : Start, Error : Invalid Start Input File Path - " + input.getAttribute("InputFile"));
                }
                if (this.disableMocking) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## Mocking will be disabled for all Mocked Activities. DisableMocking :" + this.disableMocking + " ##"));
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                }
                if (this.disableAssertions) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## All Assertions will be disabled. DisableAssertions :" + this.disableAssertions + " ##"));
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                }
                if (testcase.getAssertionList().isEmpty() && testcase.getMockActivityList().isEmpty() && !this.disableMocking && !this.disableAssertions) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("No assertions and Mock Activities found in the Test File : " + testcase.getTestCaseFile() + " . Skipping the running of file."));
                    continue;
                }
                testset.getTestCaseList().add(testcase);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setGoldData(String assertionMode, String expression, AssertionDTO ast, String inputFile) {
        switch (assertionMode) {
            case "Primitive": {
                String elementNameString;
                String[] elementNameArray;
                String elementName;
                String goldValueWithElement = StringUtils.substringBetween((String)expression, (String)"test=\"", (String)"\">");
                String goldValue = StringUtils.substringAfter((String)goldValueWithElement, (String)"=");
                if (goldValue.contains("'")) {
                    goldValue = StringUtils.substringBetween((String)goldValue, (String)"'");
                }
                if (goldValue.equals("xsd:boolean(1)") || goldValue.equals("xsd:boolean(0)")) {
                    String temp = StringUtils.substringBetween((String)goldValue, (String)"(", (String)")");
                    goldValue = temp.equals("1") ? "true" : "false";
                }
                if ((elementName = (elementNameArray = StringUtils.split((String)(elementNameString = StringUtils.substringBefore((String)goldValueWithElement, (String)"=")), (String)"/"))[elementNameArray.length - 1]).contains(")")) {
                    elementName = StringUtils.removeEnd((String)elementName, (String)")");
                }
                String startElementTag = "<".concat(elementName).concat(">");
                String endElementTag = "</".concat(elementName).concat(">");
                ast.setGoldInput(startElementTag.concat(goldValue).concat(endElementTag));
                ast.setStartElementNameTag(startElementTag);
                ast.setEndElementNameTag(endElementTag);
                break;
            }
            case "Activity": {
                String activityGoldValue = StringUtils.substringBetween((String)expression, (String)"<xsl:variable name=\"AssertType\" as=\"item()*\"><Activity-Assertion>", (String)"</Activity-Assertion>");
                activityGoldValue = StringUtils.replace((String)activityGoldValue, (String)"<xsl:value-of select=\"&quot;", (String)"");
                activityGoldValue = StringUtils.replace((String)activityGoldValue, (String)"&quot;\"  />", (String)"");
                ast.setGoldInput(activityGoldValue);
                break;
            }
            case "ActivityWithGoldFile": {
                ast.setGoldInput(this.readXMLFile(inputFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> collectSkipInitActivities(String contents) {
        InputStream is = null;
        HashSet<String> skipInitActivitiesSet = new HashSet<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            Document document = builder.parse(is);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                String componentName = null;
                Element el = (Element)node;
                if (!"ProcessNode".equals(el.getNodeName())) continue;
                String processId = el.getAttributes().getNamedItem("Id").getNodeValue();
                String key = "-DTest" + processId + "=true";
                skipInitActivitiesSet.add(key);
                if (null != el.getAttributes().getNamedItem("componentProcessName")) {
                    componentName = el.getAttributes().getNamedItem("componentProcessName").getNodeValue();
                }
                NodeList childNodes = el.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    String serviceName;
                    Element input;
                    NodeList inputNodes;
                    String activityName;
                    Node cNode = childNodes.item(j);
                    if (!(cNode instanceof Element)) continue;
                    Element cEl = (Element)cNode;
                    if ("MockActivity".equals(cEl.getNodeName())) {
                        MockActivityDTO mockActivity = new MockActivityDTO();
                        String location = cEl.getAttributes().getNamedItem("Id").getNodeValue();
                        mockActivity.setLocation(location);
                        if (this.disableMocking || null == (activityName = cEl.getAttributes().getNamedItem("Name").getNodeValue())) continue;
                        skipInitActivitiesSet.add("-D" + processId + activityName + "=true");
                        continue;
                    }
                    if (!"Operation".equals(cEl.getNodeName())) continue;
                    if (null != componentName && !componentName.isEmpty() && (inputNodes = cEl.getElementsByTagName("Inputs")) != null && inputNodes.getLength() > 0 && null != (activityName = (input = (Element)inputNodes.item(0)).getAttribute("Name"))) {
                        skipInitActivitiesSet.add("-D" + processId + activityName + "=true");
                    }
                    if (null == (serviceName = cEl.getAttribute("restOperationName")) || !serviceName.equals("SOAP")) continue;
                    skipInitActivitiesSet.add("-DskipSOAPReferenceBinding=true");
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return skipInitActivitiesSet;
    }

    private boolean validateMockXMLFile(String mockOutputFilePath, String activityName, String processName) throws Exception {
        File mockOutputFile = new File(mockOutputFilePath);
        if (mockOutputFile.exists()) {
            try {
                String mockOutputString = this.readXMLFile(mockOutputFilePath);
                DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(mockOutputString)));
                return true;
            }
            catch (Exception e) {
                String errorMessage = "Process : " + processName + ", Activity : " + activityName + "Error : Provided XML file " + mockOutputFilePath + " is not valid";
                BWTestConfig.INSTANCE.getLogger().error((CharSequence)errorMessage, (Throwable)e);
                throw e;
            }
        }
        String errorMessage = "Process : " + processName + ", Activity : " + activityName + ", Error: Provided XML file " + mockOutputFilePath + " is not Present";
        BWTestConfig.INSTANCE.getLogger().error((CharSequence)errorMessage, (Throwable)new FileNotFoundException());
        throw new Exception();
    }

    private String readXMLFile(String mockOutputFilePath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(mockOutputFilePath));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                sb.append(sCurrentLine);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return sb.toString();
    }

    public void setdisbleMocking(boolean disableMocking) {
        this.disableMocking = disableMocking;
    }

    public void setdisbleAssertions(boolean disableAssertions) {
        this.disableAssertions = disableAssertions;
    }

    public void setshowFailureDetails(boolean showFailureDetails) {
        this.showFailureDetails = showFailureDetails;
    }

    public boolean getshowFailureDetails() {
        return this.showFailureDetails;
    }

    private TestSetDTO getProcessTestSet(String processName, TestSuiteDTO suite) {
        for (int i = 0; i < suite.getTestSetList().size(); ++i) {
            if (suite.getTestSetList().get(i) == null || !((TestSetDTO)suite.getTestSetList().get(i)).getProcessName().equals(processName)) continue;
            return (TestSetDTO)suite.getTestSetList().get(i);
        }
        TestSetDTO set = new TestSetDTO();
        set.setProcessName(processName);
        suite.getTestSetList().add(set);
        return set;
    }
}

