/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.tci.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tibco.bw.maven.plugin.admin.client.ClientException;
import com.tibco.bw.maven.plugin.tci.dto.TCIAppId;
import com.tibco.bw.maven.plugin.tci.dto.TCIAppStatus;
import com.tibco.bw.maven.plugin.tci.dto.TCIError;
import com.tibco.bw.maven.plugin.tci.dto.TCIOrganization;
import com.tibco.bw.maven.plugin.tci.dto.TCIProperty;
import com.tibco.bw.maven.plugin.tci.dto.TCIUserInfo;
import com.tibco.bw.maven.plugin.tci.dto.TCIVariables;
import com.tibco.bw.maven.plugin.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class TCIDeployer {
    private String serverEndpoint = "api.cloud.tibco.com";
    private String oAuthAccessToken;
    private String contextRoot = "/tci/v1/";
    private Client jerseyClient;
    private WebTarget r;
    private final int connectTimeout;
    private final int readTimeout;
    private final int retryCount;
    private Log log;
    private int SLEEP_INTERVAL = 2000;

    public TCIDeployer(int connectTimeout, int readTimeout, int retryCount, Log log) throws Exception {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.retryCount = retryCount;
        this.log = log;
        if (System.getenv("TCI_PLATFORM_API_ENDPOINT") != null && System.getenv("TCI_PLATFORM_API_ENDPOINT").trim().length() > 0) {
            this.serverEndpoint = System.getenv("TCI_PLATFORM_API_ENDPOINT");
        }
        if (System.getenv("TCI_PLATFORM_API_ACCESS_TOKEN") == null || System.getenv("TCI_PLATFORM_API_ACCESS_TOKEN").trim().length() <= 0) {
            throw new Exception("TCI Access token is missing. Please set environment variable TCI_PLATFORM_API_ACCESS_TOKEN");
        }
        this.oAuthAccessToken = System.getenv("TCI_PLATFORM_API_ACCESS_TOKEN");
        if (System.getenv("TCI_PLATFORM_SUBSCRIPTION_LOCATOR") != null && System.getenv("TCI_PLATFORM_SUBSCRIPTION_LOCATOR").trim().length() > 0) {
            this.contextRoot = this.contextRoot + "subscriptions/" + System.getenv("TCI_PLATFORM_SUBSCRIPTION_LOCATOR") + "/apps";
            this.log.info((CharSequence)("Using Subscription Locator -> " + System.getenv("TCI_PLATFORM_SUBSCRIPTION_LOCATOR")));
        } else {
            String subscriptionLocator = "0";
            this.contextRoot = this.contextRoot + "subscriptions/" + subscriptionLocator + "/apps";
            this.log.info((CharSequence)("The environment variable TCI_PLATFORM_SUBSCRIPTION_LOCATOR is not set. Using Subscription Locator -> " + subscriptionLocator));
        }
        this.init();
    }

    private void init() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig = clientConfig.property("jersey.config.client.connectTimeout", (Object)this.connectTimeout);
        clientConfig = clientConfig.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
        clientConfig.register(JacksonFeature.class).register(MultiPartFeature.class);
        if (this.log.isDebugEnabled()) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            clientConfig.register((Object)new LoggingFilter(logger, true));
        }
        SslConfigurator sslConfig = SslConfigurator.newInstance();
        this.jerseyClient = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig).sslContext(sslConfig.createSSLContext()).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        Feature feature = OAuth2ClientSupport.feature((String)this.oAuthAccessToken);
        this.jerseyClient.register((Object)feature);
        this.r = this.jerseyClient.target(UriBuilder.fromPath((String)this.contextRoot).scheme("https").host(this.serverEndpoint).port(443).build(new Object[0]));
    }

    public void close() {
        if (this.jerseyClient != null) {
            this.jerseyClient.close();
            this.jerseyClient = null;
        }
    }

    private String getCurrentOrgSubscriptionLocator() throws ClientException {
        String subscriptionLocator = null;
        Response response = this.r.path("userinfo").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        this.processErrorResponse(response);
        TCIUserInfo tciUserInfo = (TCIUserInfo)response.readEntity(TCIUserInfo.class);
        for (TCIOrganization org : tciUserInfo.getOrganizations()) {
            if (!org.isCurrentOrg()) continue;
            subscriptionLocator = org.getSubscriptionLocator();
            break;
        }
        this.log.info((CharSequence)("Current User org subscription locator : " + subscriptionLocator));
        return subscriptionLocator;
    }

    public void deployApp(String appName, String earPath, int instances, String appVariablesFile, String engineVariablesFile, boolean forceOverwrite, boolean retainAppProps) throws ClientException, IOException, InterruptedException {
        if ((appVariablesFile != null && appVariablesFile.trim().length() > 0 || engineVariablesFile != null && engineVariablesFile.trim().length() > 0) && !retainAppProps) {
            this.log.info((CharSequence)("Pushing app to TCI, AppName -> " + appName));
            String appId = this.pushApp(appName, earPath, 0, forceOverwrite, retainAppProps);
            this.log.info((CharSequence)("App Push Successful, AppId -> " + appId));
            this.checkAppStatus(appId);
            if (appVariablesFile != null && appVariablesFile.trim().length() > 0) {
                this.log.info((CharSequence)("Setting App Variables from file -> " + appVariablesFile));
                this.setAppVariables(appId, appVariablesFile);
            }
            this.checkAppStatus(appId);
            if (engineVariablesFile != null && engineVariablesFile.trim().length() > 0) {
                this.log.info((CharSequence)("Setting Engine Variables from file -> " + engineVariablesFile));
                this.setEngineVariables(appId, engineVariablesFile);
            }
            this.checkAppStatus(appId);
            this.log.info((CharSequence)("Scaling app, instance count -> " + instances));
            this.scaleApp(appId, instances);
        } else {
            this.log.info((CharSequence)("Pushing app to TCI, AppName -> " + appName));
            String appId = this.pushApp(appName, earPath, instances, forceOverwrite, retainAppProps);
            this.log.info((CharSequence)("App Push Successful, AppId -> " + appId));
        }
    }

    private void checkAppStatus(String appId) throws ClientException, InterruptedException {
        String appStatus = "updating";
        for (int count = 0; ("updating".equalsIgnoreCase(appStatus) || "building".equalsIgnoreCase(appStatus) || "scaling".equalsIgnoreCase(appStatus)) && count < this.retryCount; ++count) {
            Thread.sleep(this.SLEEP_INTERVAL);
            Response response = this.r.path(appId).path("status").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
            this.processErrorResponse(response);
            TCIAppStatus tciAppStatus = (TCIAppStatus)response.readEntity(TCIAppStatus.class);
            this.log.info((CharSequence)("App Status -> AppId : " + appId + ", Status : " + tciAppStatus.getStatus()));
            appStatus = tciAppStatus.getStatus();
        }
    }

    private boolean isValidURL(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void setAppVariables(String appId, String variablesFile) throws IOException, ClientException {
        String variablesFileContent;
        if (variablesFile.contains("http") && this.isValidURL(variablesFile)) {
            String localFileName = variablesFile.substring(variablesFile.lastIndexOf("/") + 1);
            this.log.info((CharSequence)("App variable file is from external URL, creating temporary local file - " + localFileName));
            File file = new File(localFileName);
            file.delete();
            file.createNewFile();
            FileUtils.copyURLToFile((URL)new URL(variablesFile), (File)file);
            variablesFile = file.getAbsolutePath();
        }
        if (null != (variablesFileContent = new String(Files.readAllBytes(Paths.get(variablesFile, new String[0])))) && !variablesFileContent.isEmpty() && !variablesFileContent.equals("\n[\n]")) {
            Response response = this.r.queryParam("variableType", new Object[]{"app"}).path(appId).path("env").path("variables").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)variablesFileContent, (String)"application/json"));
            this.processErrorResponse(response);
            this.log.info((CharSequence)("Successfully updated application variables for app : " + appId));
        } else {
            this.log.info((CharSequence)("Application Variable not found in" + variablesFile + "for app : " + appId));
        }
    }

    private void setEngineVariables(String appId, String variablesFile) throws IOException, ClientException {
        Response response;
        if (variablesFile.contains("http") && this.isValidURL(variablesFile)) {
            String localFileName = variablesFile.substring(variablesFile.lastIndexOf("/") + 1);
            this.log.info((CharSequence)("Engine variable file is from external URL, creating temporary local file - " + localFileName));
            File file = new File(localFileName);
            file.delete();
            file.createNewFile();
            FileUtils.copyURLToFile((URL)new URL(variablesFile), (File)file);
            variablesFile = file.getAbsolutePath();
        }
        String variablesFileContent = new String(Files.readAllBytes(Paths.get(variablesFile, new String[0])));
        ObjectMapper objectMapper = new ObjectMapper();
        List engineProps = (List)objectMapper.readValue(variablesFileContent, (TypeReference)new TypeReference<List<TCIProperty>>(){});
        Response resp = this.r.queryParam("variableType", new Object[]{"user"}).path(appId).path("env").path("variables").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        this.processErrorResponse(resp);
        TCIVariables existingUserEngineProps = (TCIVariables)resp.readEntity(TCIVariables.class);
        this.log.info((CharSequence)("Fetched existing user engine variables for app : " + appId));
        ArrayList<TCIProperty> updateEnginePropsList = new ArrayList<TCIProperty>();
        ArrayList<TCIProperty> newUserEnginePropsList = new ArrayList<TCIProperty>();
        ArrayList<TCIProperty> updateUserEnginePropsList = new ArrayList<TCIProperty>();
        for (TCIProperty tciProperty : engineProps) {
            if (Constants.TCI_DEFAULT_ENGINE_PROPS.contains(tciProperty.getName())) {
                updateEnginePropsList.add(tciProperty);
                continue;
            }
            boolean found = false;
            if (existingUserEngineProps.getUserVariables() != null) {
                for (TCIProperty tciProp : existingUserEngineProps.getUserVariables()) {
                    if (!tciProp.getName().equalsIgnoreCase(tciProperty.getName())) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                updateUserEnginePropsList.add(tciProperty);
                continue;
            }
            newUserEnginePropsList.add(tciProperty);
        }
        if (!updateEnginePropsList.isEmpty()) {
            String updateEnginePropsListStr = objectMapper.writeValueAsString(updateEnginePropsList);
            this.log.debug((CharSequence)("Updating engine variables -> " + updateEnginePropsListStr));
            response = this.r.queryParam("variableType", new Object[]{"engine"}).path(appId).path("env").path("variables").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)updateEnginePropsListStr, (String)"application/json"));
            this.processErrorResponse(response);
            this.log.info((CharSequence)("Successfully updated engine variables for app : " + appId));
        }
        if (!newUserEnginePropsList.isEmpty()) {
            String newEnginePropsListsStr = objectMapper.writeValueAsString(newUserEnginePropsList);
            this.log.debug((CharSequence)("Adding user engine variables -> " + newEnginePropsListsStr));
            response = this.r.path(appId).path("env").path("variables").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)newEnginePropsListsStr, (String)"application/json"));
            this.processErrorResponse(response);
            this.log.info((CharSequence)("Successfully added user engine variables for app : " + appId));
        }
        if (!updateUserEnginePropsList.isEmpty()) {
            String updateUserEnginePropsListStr = objectMapper.writeValueAsString(updateUserEnginePropsList);
            this.log.debug((CharSequence)("Updating user engine variables -> " + updateUserEnginePropsListStr));
            response = this.r.queryParam("variableType", new Object[]{"user"}).path(appId).path("env").path("variables").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)updateUserEnginePropsListStr, (String)"application/json"));
            this.processErrorResponse(response);
            this.log.info((CharSequence)("Successfully updated user engine variables for app : " + appId));
        }
    }

    private String pushApp(String appName, String earPath, int instanceCount, boolean forceOverwrite, boolean retainAppProps) throws ClientException {
        this.log.info((CharSequence)("Pushing app on TCI : " + appName));
        try {
            FormDataMultiPart multipart = new FormDataMultiPart();
            File earFileEntity = new File(earPath);
            multipart.bodyPart((BodyPart)new FileDataBodyPart("artifact", earFileEntity));
            Response response = this.r.queryParam("appName", new Object[]{appName}).queryParam("instanceCount", new Object[]{instanceCount}).queryParam("forceOverwrite", new Object[]{forceOverwrite}).queryParam("retainAppProps", new Object[]{retainAppProps}).request(new String[]{"multipart/form-data"}).accept(new String[]{"application/json"}).post(Entity.entity((Object)multipart, (String)"multipart/form-data"));
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                TCIAppId tciAppId = (TCIAppId)response.readEntity(TCIAppId.class);
                return tciAppId.getAppId();
            }
            this.processErrorResponse(response);
            return null;
        }
        catch (ProcessingException pe) {
            pe.printStackTrace();
            throw TCIDeployer.getConnectionException(pe);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ClientException(500, ex.getMessage(), ex);
        }
    }

    public void scaleApp(String appId, int instances) throws ClientException {
        if (instances > 0) {
            this.log.info((CharSequence)("Scaling app : " + appId));
            Response response = this.r.queryParam("instanceCount", new Object[]{Integer.toString(instances)}).path(appId).path("scale").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(null);
            this.processErrorResponse(response);
            this.log.info((CharSequence)("Successfully submitted scale app request : " + appId + " to " + instances + " instances."));
        }
    }

    private void addQueryParam(String name, String value) {
        if (value != null) {
            this.r = this.r.queryParam(name, new Object[]{value});
        }
    }

    private void processErrorResponse(Response response) throws ClientException {
        if (!Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily())) {
            if (response.getStatusInfo().getStatusCode() == 401) {
                throw new ClientException(response.getStatus(), response.getStatusInfo().getStatusCode() + ": " + response.getStatusInfo().getReasonPhrase(), null);
            }
            TCIError error = (TCIError)response.readEntity(TCIError.class);
            if (error != null) {
                throw new ClientException(response.getStatus(), error.getError() + ": " + error.getErrorDetail(), null);
            }
            throw new ClientException(response.getStatus(), response.getStatusInfo().getReasonPhrase(), null);
        }
    }

    private static ClientException getConnectionException(ProcessingException pe) {
        if (pe.getCause() instanceof ConnectException) {
            return new ClientException(503, pe.getCause().getMessage(), pe.getCause());
        }
        if (pe.getCause() instanceof IllegalStateException) {
            return new ClientException(503, pe.getCause().getMessage(), pe.getCause());
        }
        return new ClientException(500, pe.getMessage(), pe);
    }
}

