/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.build;

import com.tibco.bw.maven.plugin.build.BuildProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class BuildPropertiesImpl
implements BuildProperties {
    private List<String> binIncludes;
    private List<String> binExcludes;
    private List<String> sourceIncludes;
    private List<String> sourceExcludes;

    public BuildPropertiesImpl(Properties properties) {
        this.init(properties);
    }

    public void init(Properties properties) {
        this.sourceIncludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("src.includes"));
        this.sourceExcludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("src.excludes"));
        this.binIncludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("bin.includes"));
        this.binExcludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("bin.excludes"));
    }

    private static List<String> splitAndTrimCommaSeparated(String rawValue) {
        ArrayList<String> result = new ArrayList<String>();
        if (rawValue != null) {
            for (String element : rawValue.split(",")) {
                result.add(element.trim());
            }
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<String> getBinIncludes() {
        return this.binIncludes;
    }

    public void setBinIncludes(List<String> binIncludes) {
        this.binIncludes = binIncludes;
    }

    @Override
    public List<String> getBinExcludes() {
        return this.binExcludes;
    }

    public void setBinExcludes(List<String> binExcludes) {
        this.binExcludes = binExcludes;
    }

    @Override
    public List<String> getSourceIncludes() {
        return this.sourceIncludes;
    }

    public void setSourceIncludes(List<String> sourceIncludes) {
        this.sourceIncludes = sourceIncludes;
    }

    @Override
    public List<String> getSourceExcludes() {
        return this.sourceExcludes;
    }

    public void setSourceExcludes(List<String> sourceExcludes) {
        this.sourceExcludes = sourceExcludes;
    }
}

