/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2.util;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.util.ParamsRetriever;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NamedParamsRetriever
extends ParamsRetriever {
    private Map<String, Object> params = null;

    private static void throwMissingParameterException(String ... names) throws JSONRPC2Error {
        if (names.length == 1) {
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Missing \"" + names[0] + "\" parameter");
        }
        StringBuilder list = new StringBuilder();
        for (String name : names) {
            if (list.length() > 0) {
                list.append(',');
            }
            list.append('\"');
            list.append(name);
            list.append('\"');
        }
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Missing " + list.toString() + " parameters");
    }

    private static void throwNullParameterException(String name) throws JSONRPC2Error {
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(": Parameter \"" + name + "\" must not be null");
    }

    private static void throwEnumParameterException(String name, String[] enumStrings) throws JSONRPC2Error {
        StringBuilder msg = new StringBuilder(": Enumerated parameter \"" + name + "\" must have values ");
        for (int i = 0; i < enumStrings.length; ++i) {
            if (i > 0 && i == enumStrings.length - 1) {
                msg.append(" or ");
            } else if (i > 0) {
                msg.append(", ");
            }
            msg.append('\"');
            msg.append(enumStrings[i]);
            msg.append('\"');
        }
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(msg.toString());
    }

    private static <T extends Enum<T>> void throwEnumParameterException(String name, Class<T> enumClass) throws JSONRPC2Error {
        StringBuilder msg = new StringBuilder(": Enumerated parameter \"" + name + "\" must have values ");
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < constants.length; ++i) {
            if (i > 0 && i == constants.length - 1) {
                msg.append(" or ");
            } else if (i > 0) {
                msg.append(", ");
            }
            msg.append('\"');
            msg.append(constants[i].toString());
            msg.append('\"');
        }
        throw JSONRPC2Error.INVALID_PARAMS.appendMessage(msg.toString());
    }

    private static JSONRPC2Error newUnexpectedParameterTypeException(String name) {
        return JSONRPC2Error.INVALID_PARAMS.appendMessage(": Parameter \"" + name + "\" has an unexpected JSON type");
    }

    private static JSONRPC2Error newArrayException(String name) {
        return JSONRPC2Error.INVALID_PARAMS.appendMessage(": Parameter \"" + name + "\" caused an array exception");
    }

    public NamedParamsRetriever(Map<String, Object> params) {
        if (params == null) {
            throw new IllegalArgumentException("The parameters map must not be null");
        }
        this.params = params;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    @Deprecated
    public boolean hasParameter(String name) {
        return this.hasParam(name);
    }

    public boolean hasParams(String[] names) {
        return this.hasParams(names, null);
    }

    @Deprecated
    public boolean hasParameters(String[] names) {
        return this.hasParams(names);
    }

    public boolean hasParams(String[] mandatoryNames, String[] optionalNames) {
        int remainingKeys;
        Map paramsCopy = (Map)((HashMap)this.params).clone();
        for (String name : mandatoryNames) {
            if (!paramsCopy.containsKey(name)) {
                return false;
            }
            paramsCopy.remove(name);
        }
        if (optionalNames != null) {
            for (String name : optionalNames) {
                if (!paramsCopy.containsKey(name)) continue;
                paramsCopy.remove(name);
            }
        }
        return (remainingKeys = paramsCopy.size()) == 0;
    }

    @Deprecated
    public boolean hasParameters(String[] mandatoryNames, String[] optionalNames) {
        return this.hasParams(mandatoryNames, optionalNames);
    }

    public String[] getNames() {
        Set<String> keySet = this.params.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public void ensureParams(String[] mandatoryNames) throws JSONRPC2Error {
        this.ensureParameters(mandatoryNames, null);
    }

    @Deprecated
    public void ensureParameters(String[] mandatoryNames) throws JSONRPC2Error {
        this.ensureParams(mandatoryNames);
    }

    public void ensureParams(String[] mandatoryNames, String[] optionalNames) throws JSONRPC2Error {
        if (!this.hasParameters(mandatoryNames, optionalNames)) {
            NamedParamsRetriever.throwMissingParameterException(mandatoryNames);
        }
    }

    @Deprecated
    public void ensureParameters(String[] mandatoryNames, String[] optionalNames) throws JSONRPC2Error {
        this.ensureParams(mandatoryNames, optionalNames);
    }

    public void ensureParam(String name) throws JSONRPC2Error {
        if (!this.hasParameter(name)) {
            NamedParamsRetriever.throwMissingParameterException(name);
        }
    }

    @Deprecated
    public void ensureParameter(String name) throws JSONRPC2Error {
        this.ensureParam(name);
    }

    public <T> void ensureParam(String name, Class<T> clazz) throws JSONRPC2Error {
        this.ensureParameter(name, clazz, false);
    }

    @Deprecated
    public <T> void ensureParameter(String name, Class<T> clazz) throws JSONRPC2Error {
        this.ensureParam(name, clazz);
    }

    public <T> void ensureParam(String name, Class<T> clazz, boolean allowNull) throws JSONRPC2Error {
        this.ensureParameter(name);
        Object value = this.params.get(name);
        if (value == null) {
            if (allowNull) {
                return;
            }
            NamedParamsRetriever.throwNullParameterException(name);
        }
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw NamedParamsRetriever.newUnexpectedParameterTypeException(name);
        }
    }

    @Deprecated
    public <T> void ensureParameter(String name, Class<T> clazz, boolean allowNull) throws JSONRPC2Error {
        this.ensureParam(name, clazz, allowNull);
    }

    public Object get(String name) throws JSONRPC2Error {
        this.ensureParameter(name);
        return this.params.get(name);
    }

    public <T> T get(String name, Class<T> clazz) throws JSONRPC2Error {
        return this.get(name, clazz, false);
    }

    public <T> T get(String name, Class<T> clazz, boolean allowNull) throws JSONRPC2Error {
        this.ensureParameter(name, clazz, allowNull);
        try {
            return (T)this.params.get(name);
        }
        catch (ClassCastException e) {
            throw NamedParamsRetriever.newUnexpectedParameterTypeException(name);
        }
    }

    public <T> T getOpt(String name, Class<T> clazz, T defaultValue) throws JSONRPC2Error {
        return this.getOpt(name, clazz, false, defaultValue);
    }

    public <T> T getOpt(String name, Class<T> clazz, boolean allowNull, T defaultValue) throws JSONRPC2Error {
        if (!this.hasParameter(name)) {
            return defaultValue;
        }
        this.ensureParameter(name, clazz, allowNull);
        try {
            return (T)this.params.get(name);
        }
        catch (ClassCastException e) {
            throw NamedParamsRetriever.newUnexpectedParameterTypeException(name);
        }
    }

    public String getString(String name) throws JSONRPC2Error {
        return this.getString(name, false);
    }

    public String getString(String name, boolean allowNull) throws JSONRPC2Error {
        return this.get(name, String.class, allowNull);
    }

    public String getOptString(String name, String defaultValue) throws JSONRPC2Error {
        return this.getOptString(name, false, defaultValue);
    }

    public String getOptString(String name, boolean allowNull, String defaultValue) throws JSONRPC2Error {
        return this.getOpt(name, String.class, allowNull, defaultValue);
    }

    public String getEnumString(String name, String[] enumStrings) throws JSONRPC2Error {
        return this.getEnumString(name, enumStrings, false);
    }

    public String getEnumString(String name, String[] enumStrings, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.get(name, String.class);
        String match = NamedParamsRetriever.getEnumStringMatch(value, enumStrings, ignoreCase);
        if (match == null) {
            NamedParamsRetriever.throwEnumParameterException(name, enumStrings);
        }
        return match;
    }

    public String getOptEnumString(String name, String[] enumStrings, String defaultValue) throws JSONRPC2Error {
        return this.getOptEnumString(name, enumStrings, defaultValue, false);
    }

    public String getOptEnumString(String name, String[] enumStrings, String defaultValue, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.getOpt(name, String.class, defaultValue);
        if (defaultValue == null && value == null) {
            return null;
        }
        String match = NamedParamsRetriever.getEnumStringMatch(value, enumStrings, ignoreCase);
        if (match == null) {
            NamedParamsRetriever.throwEnumParameterException(name, enumStrings);
        }
        return match;
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) throws JSONRPC2Error {
        return this.getEnum(name, enumClass, false);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass, boolean ignoreCase) throws JSONRPC2Error {
        String value = this.get(name, String.class);
        T match = NamedParamsRetriever.getEnumStringMatch(value, enumClass, ignoreCase);
        if (match == null) {
            NamedParamsRetriever.throwEnumParameterException(name, enumClass);
        }
        return match;
    }

    public <T extends Enum<T>> T getOptEnum(String name, Class<T> enumClass, T defaultValue) throws JSONRPC2Error {
        return this.getOptEnum(name, enumClass, defaultValue, false);
    }

    public <T extends Enum<T>> T getOptEnum(String name, Class<T> enumClass, T defaultValue, boolean ignoreCase) throws JSONRPC2Error {
        String value = defaultValue != null ? this.getOpt(name, String.class, defaultValue.toString()) : (String)this.getOpt(name, String.class, null);
        if (defaultValue == null && value == null) {
            return null;
        }
        T match = NamedParamsRetriever.getEnumStringMatch(value, enumClass, ignoreCase);
        if (match == null) {
            NamedParamsRetriever.throwEnumParameterException(name, enumClass);
        }
        return match;
    }

    public boolean getBoolean(String name) throws JSONRPC2Error {
        return this.get(name, Boolean.class);
    }

    public boolean getOptBoolean(String name, boolean defaultValue) throws JSONRPC2Error {
        return this.getOpt(name, Boolean.class, defaultValue);
    }

    public int getInt(String name) throws JSONRPC2Error {
        Number number = this.get(name, Number.class);
        return number.intValue();
    }

    public int getOptInt(String name, int defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(name, Number.class, defaultValue);
        return number.intValue();
    }

    public long getLong(String name) throws JSONRPC2Error {
        Number number = this.get(name, Number.class);
        return number.longValue();
    }

    public long getOptLong(String name, long defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(name, Number.class, defaultValue);
        return number.longValue();
    }

    public float getFloat(String name) throws JSONRPC2Error {
        Number number = this.get(name, Number.class);
        return number.floatValue();
    }

    public float getOptFloat(String name, float defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(name, Number.class, Float.valueOf(defaultValue));
        return number.floatValue();
    }

    public double getDouble(String name) throws JSONRPC2Error {
        Number number = this.get(name, Number.class);
        return number.doubleValue();
    }

    public double getOptDouble(String name, double defaultValue) throws JSONRPC2Error {
        Number number = this.getOpt(name, Number.class, defaultValue);
        return number.doubleValue();
    }

    public List<Object> getList(String name) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getList(name, false);
    }

    public List<Object> getList(String name, boolean allowNull) throws JSONRPC2Error {
        return this.get(name, List.class, allowNull);
    }

    public List<Object> getOptList(String name, List<Object> defaultValue) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getOptList(name, false, defaultValue);
    }

    public List<Object> getOptList(String name, boolean allowNull, List<Object> defaultValue) throws JSONRPC2Error {
        return this.getOpt(name, List.class, allowNull, defaultValue);
    }

    public String[] getStringArray(String name) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getStringArray(name, false);
    }

    public String[] getStringArray(String name, boolean allowNull) throws JSONRPC2Error {
        List<Object> list = this.getList(name, allowNull);
        if (list == null) {
            return null;
        }
        try {
            return list.toArray(new String[list.size()]);
        }
        catch (ArrayStoreException e) {
            throw NamedParamsRetriever.newArrayException(name);
        }
    }

    public String[] getOptStringArray(String name, String[] defaultValue) throws JSONRPC2Error {
        boolean allowNull = false;
        return this.getOptStringArray(name, false, defaultValue);
    }

    public String[] getOptStringArray(String name, boolean allowNull, String[] defaultValue) throws JSONRPC2Error {
        if (!this.hasParameter(name)) {
            return defaultValue;
        }
        return this.getStringArray(name, allowNull);
    }

    public Map<String, Object> getMap(String name) throws JSONRPC2Error {
        return this.getMap(name, false);
    }

    public Map<String, Object> getMap(String name, boolean allowNull) throws JSONRPC2Error {
        try {
            return this.get(name, Map.class, allowNull);
        }
        catch (ClassCastException e) {
            throw NamedParamsRetriever.newUnexpectedParameterTypeException(name);
        }
    }

    public Map<String, Object> getOptMap(String name, Map<String, Object> defaultValue) throws JSONRPC2Error {
        return this.getOptMap(name, false, defaultValue);
    }

    public Map<String, Object> getOptMap(String name, boolean allowNull, Map<String, Object> defaultValue) throws JSONRPC2Error {
        try {
            return this.getOpt(name, Map.class, allowNull, defaultValue);
        }
        catch (ClassCastException e) {
            throw NamedParamsRetriever.newUnexpectedParameterTypeException(name);
        }
    }
}

