/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParamsType;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Parser;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class JSONRPC2Notification
extends JSONRPC2Message {
    private String method;
    private List<Object> positionalParams;
    private Map<String, Object> namedParams;

    public static JSONRPC2Notification parse(String jsonString) throws JSONRPC2ParseException {
        return JSONRPC2Notification.parse(jsonString, false, false, false);
    }

    public static JSONRPC2Notification parse(String jsonString, boolean preserveOrder) throws JSONRPC2ParseException {
        return JSONRPC2Notification.parse(jsonString, preserveOrder, false, false);
    }

    public static JSONRPC2Notification parse(String jsonString, boolean preserveOrder, boolean ignoreVersion) throws JSONRPC2ParseException {
        return JSONRPC2Notification.parse(jsonString, preserveOrder, ignoreVersion, false);
    }

    public static JSONRPC2Notification parse(String jsonString, boolean preserveOrder, boolean ignoreVersion, boolean parseNonStdAttributes) throws JSONRPC2ParseException {
        JSONRPC2Parser parser = new JSONRPC2Parser(preserveOrder, ignoreVersion, parseNonStdAttributes);
        return parser.parseJSONRPC2Notification(jsonString);
    }

    public JSONRPC2Notification(String method) {
        this.setMethod(method);
        this.setParams(null);
    }

    public JSONRPC2Notification(String method, List<Object> positionalParams) {
        this.setMethod(method);
        this.setPositionalParams(positionalParams);
    }

    public JSONRPC2Notification(String method, Map<String, Object> namedParams) {
        this.setMethod(method);
        this.setNamedParams(namedParams);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        this.method = method;
    }

    public JSONRPC2ParamsType getParamsType() {
        if (this.positionalParams == null && this.namedParams == null) {
            return JSONRPC2ParamsType.NO_PARAMS;
        }
        if (this.positionalParams != null) {
            return JSONRPC2ParamsType.ARRAY;
        }
        if (this.namedParams != null) {
            return JSONRPC2ParamsType.OBJECT;
        }
        return JSONRPC2ParamsType.NO_PARAMS;
    }

    @Deprecated
    public Object getParams() {
        switch (this.getParamsType()) {
            case ARRAY: {
                return this.positionalParams;
            }
            case OBJECT: {
                return this.namedParams;
            }
        }
        return null;
    }

    public List<Object> getPositionalParams() {
        return this.positionalParams;
    }

    public Map<String, Object> getNamedParams() {
        return this.namedParams;
    }

    @Deprecated
    public void setParams(Object params) {
        if (params == null) {
            this.positionalParams = null;
            this.namedParams = null;
        } else if (params instanceof List) {
            this.positionalParams = (List)params;
        } else if (params instanceof Map) {
            this.namedParams = (Map)params;
        } else {
            throw new IllegalArgumentException("The notification parameters must be of type List, Map or null");
        }
    }

    public void setPositionalParams(List<Object> positionalParams) {
        if (positionalParams == null) {
            return;
        }
        this.positionalParams = positionalParams;
    }

    public void setNamedParams(Map<String, Object> namedParams) {
        if (namedParams == null) {
            return;
        }
        this.namedParams = namedParams;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject notf = new JSONObject();
        notf.put((Object)"method", (Object)this.method);
        switch (this.getParamsType()) {
            case ARRAY: {
                notf.put((Object)"params", this.positionalParams);
                break;
            }
            case OBJECT: {
                notf.put((Object)"params", this.namedParams);
            }
        }
        notf.put((Object)"jsonrpc", (Object)"2.0");
        Map<String, Object> nonStdAttributes = this.getNonStdAttributes();
        if (nonStdAttributes != null) {
            for (Map.Entry<String, Object> attr : nonStdAttributes.entrySet()) {
                notf.put((Object)attr.getKey(), attr.getValue());
            }
        }
        return notf;
    }
}

