/*
 * Decompiled with CFR 0.152.
 */
package protocbridge;

import java.nio.charset.Charset;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.runtime.BoxesRunTime;

public final class ProtoUtils$ {
    public static final ProtoUtils$ MODULE$ = new ProtoUtils$();
    private static final int WIRETYPE_LENGTH_DELIMITED = 2;
    private static final int TAG_TYPE_BITS = 3;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public void writeRawVarint32(ArrayBuilder<Object> output, int value0) {
        int value = value0;
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                output.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)value)));
                return;
            }
            output.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(value & 0x7F | 0x80))));
            value >>>= 7;
        }
    }

    public int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeTag(ArrayBuilder<Object> b, int fieldNumber, int wireType) {
        this.writeRawVarint32(b, this.makeTag(fieldNumber, wireType));
    }

    public void writeString(ArrayBuilder<Object> b, int fieldNumber, String value) {
        this.writeTag(b, fieldNumber, this.WIRETYPE_LENGTH_DELIMITED());
        this.writeStringNoTag(b, value);
    }

    public void writeBytes(ArrayBuilder<Object> b, int fieldNumber, byte[] value) {
        this.writeTag(b, fieldNumber, this.WIRETYPE_LENGTH_DELIMITED());
        this.writeBytesNoTag(b, value);
    }

    public ArrayBuilder<Object> writeBytesNoTag(ArrayBuilder<Object> b, byte[] value) {
        this.writeRawVarint32(b, value.length);
        return (ArrayBuilder)b.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapByteArray(value));
    }

    public void writeStringNoTag(ArrayBuilder<Object> b, String value) {
        byte[] bytes = value.getBytes(this.UTF_8());
        this.writeBytesNoTag(b, bytes);
    }

    public int computeTagSize(int fieldNumber) {
        return this.computeRawVarint32Size(this.makeTag(fieldNumber, 0));
    }

    public int computeStringSize(int fieldNumber, String s) {
        int sz = s.getBytes(this.UTF_8()).length;
        return this.computeTagSize(fieldNumber) + this.computeRawVarint32Size(sz) + sz;
    }

    public int WIRETYPE_LENGTH_DELIMITED() {
        return WIRETYPE_LENGTH_DELIMITED;
    }

    public int TAG_TYPE_BITS() {
        return TAG_TYPE_BITS;
    }

    public int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << this.TAG_TYPE_BITS() | wireType;
    }

    public Charset UTF_8() {
        return UTF_8;
    }

    private ProtoUtils$() {
    }
}

