/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.ListArray;
import com.teradata.tdgss.jgssp2td2.ASN1TokenHdr;

public class ASN1Msg {
    private ASN1TokenHdr asn1TokenHdr = null;
    private byte[] inputMsg = null;
    private byte[] computedMac = null;
    private byte[] authTag = null;
    private boolean isAuthTag = false;
    private boolean isComputedMac = false;

    public ASN1TokenHdr getAsn1TokenHdr() {
        return this.asn1TokenHdr;
    }

    public void setAsn1TokenHdr(ASN1TokenHdr aSN1TokenHdr) {
        this.asn1TokenHdr = aSN1TokenHdr;
    }

    public byte[] getInputMsg() {
        return (byte[])this.inputMsg.clone();
    }

    public void setInputMsg(byte[] byArray) {
        this.inputMsg = (byte[])byArray.clone();
    }

    public byte[] getComputedMac() {
        return (byte[])this.computedMac.clone();
    }

    public void setComputedMac(byte[] byArray) {
        this.computedMac = (byte[])byArray.clone();
        this.isComputedMac = true;
    }

    public byte[] getAuthTag() {
        return (byte[])this.authTag.clone();
    }

    public void setAuthTag(byte[] byArray) {
        this.authTag = (byte[])byArray.clone();
        this.isAuthTag = true;
    }

    public boolean isauthTagSet() {
        return this.isAuthTag;
    }

    public boolean iscomputedMacSet() {
        return this.isComputedMac;
    }

    public DER getDERObject() {
        DER dER = new DER(0, new ListArray(DER.class));
        dER.add(new DER(0, this.inputMsg));
        DER dER2 = this.asn1TokenHdr.getDERObject();
        dER.add(dER2);
        if (this.isComputedMac) {
            dER.add(new DER(2, this.computedMac));
        }
        if (this.isAuthTag) {
            dER.add(new DER(3, this.authTag));
        }
        return dER;
    }

    public void parseDERObject(DER dER) {
        DER dER2;
        if (0 != dER.getTagNumber()) {
            throw new IllegalArgumentException("WrapUnwrap tag number is invalid");
        }
        DER dER3 = dER.getChildrenWithTag(0);
        if (dER3 == null) {
            throw new IllegalArgumentException("No input message");
        }
        this.inputMsg = dER3.getValueAsOctetString();
        DER dER4 = dER.getChildrenWithTag(1);
        if (dER4 == null) {
            throw new IllegalArgumentException("TokenHeader not found");
        }
        this.asn1TokenHdr = new ASN1TokenHdr();
        this.asn1TokenHdr.parseDERObject(dER4);
        DER dER5 = dER.getChildrenWithTag(2);
        if (dER5 != null) {
            this.computedMac = dER5.getValueAsOctetString();
            this.isComputedMac = true;
        }
        if ((dER2 = dER.getChildrenWithTag(3)) != null) {
            this.authTag = dER2.getValueAsOctetString();
            this.isAuthTag = true;
        }
    }
}

