/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ContinueContextParcel;
import com.teradata.jdbc.jdbc_4.parcel.ControlDataEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.ControlDataStartParcel;
import com.teradata.jdbc.jdbc_4.parcel.FetchRowCountParcel;
import com.teradata.jdbc.jdbc_4.parcel.OAuthTokensParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecoverableProtocolParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveParcel;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class SendState
implements TDParcelState {
    protected TDPacket packet;
    private long m_nCurrentFetchRowNumber = -1L;
    protected StatementController controller;
    protected Log log;

    public SendState(StatementController statementController) {
        this.controller = statementController;
        this.log = statementController.getSession().getLog();
    }

    protected void initializePacket(int n) throws SQLException {
        this.packet = this.controller.getSession().createPacket(n);
        this.packet.setInitParcelPosition();
        this.packet.setHostCharSet(this.controller.getSession().getTdSessionCharSetCode());
        this.packet.setSessionNumber(this.controller.getSession().getSessionNum());
        this.packet.setAuthentication(this.controller.getSession().getAuthenticationNonce());
    }

    protected StatementController getController() {
        return this.controller;
    }

    protected TDPacket getPacket() {
        return this.packet;
    }

    public void setCurrentFetchRowNumber(long l) {
        this.m_nCurrentFetchRowNumber = l;
    }

    protected void initFetchRowCountParcel(StatementReceiveState statementReceiveState) throws SQLException {
        if (this.controller.getSession().getConfigResponse().isFetchRowCountSupported()) {
            long l = statementReceiveState != null && statementReceiveState.getCurrentResultSet() != null && !statementReceiveState.getCurrentResultSet().isClosed() ? (long)statementReceiveState.getCurrentResultSet().getFetchSize() : (long)this.controller.getStatement().getFetchSize();
            int n = this.controller.getStatement().getMaxRows();
            if (n > 0) {
                boolean bl;
                boolean bl2 = statementReceiveState == null;
                boolean bl3 = bl = this.m_nCurrentFetchRowNumber >= 0L;
                if (bl2 || bl) {
                    long l2;
                    long l3 = l2 = this.m_nCurrentFetchRowNumber >= 1L ? (long)n - this.m_nCurrentFetchRowNumber + 1L : (long)n;
                    if (l2 > 0L && (l == 0L || l2 < l)) {
                        l = l2;
                    }
                }
            }
            if (l > 0L && l <= Integer.MAX_VALUE) {
                this.packet.addParcel(new FetchRowCountParcel((int)l, this.controller.getSession()));
            }
        }
    }

    protected void sendPacket() throws SQLException {
        this.packet.toStream();
        this.packet.getBuffer().writeStream(this.controller.getNetworkIO(), this.controller.getStatement(), true);
    }

    protected void initControlData() throws SQLException {
        int n;
        Object object;
        TDSession tDSession = this.controller.getSession();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String string : tDSession.m_setTokenFinders.toArray(new String[0])) {
            object = TokenCache.findToken(tDSession, string);
            if (object == null) continue;
            arrayList.add((String[])object);
        }
        OAuthTokensParcel oAuthTokensParcel = arrayList.size() > 0 ? new OAuthTokensParcel(tDSession, arrayList) : null;
        int n2 = tDSession.isRecoverableNPActive() || oAuthTokensParcel != null ? 1 : 0;
        int n3 = n = tDSession.desiredRedriveLevel() >= 1 && tDSession.databaseCapableOfRedriveLevel() >= 1 ? 1 : 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("initControlData: con.m_setTokenFinders.size=" + tDSession.m_setTokenFinders.size() + " listScopeTokenPairs.size=" + arrayList.size() + (oAuthTokensParcel == null ? " parcelTokens=null" : " parcelTokens.bodyLength=" + oAuthTokensParcel.bodyLength()) + " con.isRecoverableNPActive=" + tDSession.isRecoverableNPActive() + " con.desiredRedriveLevel=" + tDSession.desiredRedriveLevel() + " con.databaseCapableOfRedriveLevel=" + tDSession.databaseCapableOfRedriveLevel() + " bWantToSendControlData=" + (n2 != 0) + " bCanSendControlData=" + (n != 0));
        }
        if (n2 && n) {
            int n4 = 0;
            object = new ControlDataStartParcel(tDSession);
            n4 += ((Parcel)object).getLength();
            RecoverableProtocolParcel recoverableProtocolParcel = tDSession.isRecoverableNPActive() ? new RecoverableProtocolParcel(tDSession) : null;
            n4 += recoverableProtocolParcel != null ? recoverableProtocolParcel.getLength() : 0;
            RedriveParcel redriveParcel = tDSession.isRedriveActive() ? new RedriveParcel(tDSession, 1) : null;
            n4 += redriveParcel != null ? redriveParcel.getLength() : 0;
            ContinueContextParcel continueContextParcel = this.controller.getStatement().getContinueContext();
            n4 += continueContextParcel != null ? continueContextParcel.getLength() : 0;
            n4 += oAuthTokensParcel != null ? oAuthTokensParcel.getLength() : 0;
            ControlDataEndParcel controlDataEndParcel = new ControlDataEndParcel(tDSession);
            ((ControlDataStartParcel)object).setControlDataLength(n4 += controlDataEndParcel.getLength());
            controlDataEndParcel.setControlDataLength(n4);
            this.packet.addParcel((Parcel)object);
            if (recoverableProtocolParcel != null) {
                this.packet.addParcel(recoverableProtocolParcel);
            }
            if (redriveParcel != null) {
                this.packet.addParcel(redriveParcel);
            }
            if (continueContextParcel != null) {
                this.packet.addParcel(continueContextParcel);
            }
            if (oAuthTokensParcel != null) {
                this.packet.addParcel(oAuthTokensParcel);
            }
            this.packet.addParcel(controlDataEndParcel);
            this.packet.setControlDataLength(n4);
        }
    }
}

