/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.LobBuffer;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import java.io.IOException;
import java.sql.SQLException;

public class ClobAsciiStream
extends LobStream {
    protected byte[] byteData;
    protected int index = 0;
    protected int remaining = 0;

    public ClobAsciiStream(TDSession tDSession, byte[] byArray, LobBuffer lobBuffer, short s, long l) {
        super(tDSession, byArray, lobBuffer, s, l);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.remaining == 0 && (this.totalLength == 0L || (this.byteData = this.getNewByteBuff()) == null)) {
            return -1;
        }
        --this.remaining;
        ++this.amountRead;
        return this.byteData[this.index++];
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.totalLength == 0L) {
            return -1;
        }
        for (int i = n2; i > 0; i -= n3) {
            n3 = this.readBytes(byArray, n + n4, n2 - n4);
            if (n3 == -1) {
                return n4 > 0 ? n4 : -1;
            }
            n4 += n3;
        }
        return n4;
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining <= 0 && (this.byteData = this.getNewByteBuff()) == null) {
            return -1;
        }
        int n3 = n2 > this.remaining ? this.remaining : n2;
        System.arraycopy(this.byteData, this.index, byArray, n, n3);
        this.index += n3;
        this.remaining -= n3;
        this.amountRead += (long)n3;
        return n3;
    }

    private byte[] getNewByteBuff() throws IOException {
        byte[] byArray = null;
        try {
            this.initStream();
            String string = this.lobData.readClobString(this.isXMLType());
            if (string != null) {
                byArray = Encoder.encodeClobAscii(this.m_session, string, this.amountRead + 1L);
                this.remaining = byArray.length;
                this.index = 0;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
        return byArray;
    }
}

