/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.fastload.FastLoadConnection;
import com.teradata.jdbc.jdbc.fastload.FastLoadSQLOutput;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class FastLoadPreparedStatement
implements PreparedStatement {
    private FastLoadConnection con = null;
    private ArrayList paramMetaData = null;
    private List m_listRowNumbers = new ArrayList();
    private Object[] workingRow = new Object[2000];
    private BitSet workingRowColumn = new BitSet(2000);
    private ArrayList batchedRows = new ArrayList();
    private ArrayList batchedRowsUsedForValidation = null;
    private int maxDecimalPrecision = 18;
    private boolean m_bIsCharsetUTF8 = false;
    public static final int TIME_STRING_LENGTH = 8;
    public static final int TIMESTAMP_STRING_LENGTH = 19;
    public static final int TIME_ZONE_STRING_LENGTH = 6;
    public static final int MAX_COLUMN_COUNT = 2000;
    public static final long MAX_UTF8_VARCHAR_BYTE_LENGTH = 32000L;

    public FastLoadPreparedStatement(FastLoadConnection fastLoadConnection) throws SQLException {
        this.con = fastLoadConnection;
        this.batchedRowsUsedForValidation = this.batchedRows;
        this.maxDecimalPrecision = fastLoadConnection.getMaxDecimalPrecision();
        this.m_bIsCharsetUTF8 = "UTF8".equals(fastLoadConnection.getURLParameters().getCharSet());
    }

    protected void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (this.batchedRowsUsedForValidation.size() == 0) {
            if (this.paramMetaData == null) {
                if (n <= 0 || n > 2000) {
                    throw ErrorFactory.makeDriverJDBCException("TJ411", n);
                }
            } else if (n <= 0 || n > this.paramMetaData.size()) {
                throw ErrorFactory.makeDriverJDBCException("TJ169", n, this.paramMetaData.size());
            }
        } else {
            Object[] objectArray = (Object[])this.batchedRowsUsedForValidation.get(0);
            if (n <= 0 || n > objectArray.length) {
                throw ErrorFactory.makeDriverJDBCException("TJ169", n, objectArray.length);
            }
        }
    }

    private boolean isNumberDestination(int n) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (this.paramMetaData == null) {
            return false;
        }
        FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)this.paramMetaData.get(n - 1);
        return JDBC4Constants.getJavaSQLType(fullContentMetadataItem.getDataType()) == 2;
    }

    private void abortIfParameterMetaDataConflicts(int n, Object object) throws SQLException {
        if (this.paramMetaData == null || n > this.paramMetaData.size()) {
            return;
        }
        FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)this.paramMetaData.get(n - 1);
        if (object instanceof BigDecimal && !this.isNumberDestination(n)) {
            int n2;
            short s = fullContentMetadataItem.getTotalNumberOfDigits();
            BigDecimal bigDecimal = (BigDecimal)object;
            int n3 = bigDecimal.scale();
            if (n3 < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n3 = bigDecimal.scale();
            }
            if ((n2 = ComUtil.getSignificantDigits(bigDecimal) + n3) > s) {
                throw ErrorFactory.makeTDDataTruncation("TJ537", n, true, false, n2, s);
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            long l = fullContentMetadataItem.getMaxDataLengthInBytes();
            if ((long)byArray.length > l) {
                throw ErrorFactory.makeTDDataTruncation("TJ536", n, true, false, byArray.length, (int)l);
            }
        } else if (object instanceof String) {
            long l = this.m_bIsCharsetUTF8 ? Math.min(fullContentMetadataItem.getMaxDataLengthInBytes(), 32000L) : fullContentMetadataItem.getMaxDataLengthInBytes();
            byte[] byArray = Encoder.encodeStringParameter(this.con, n, (String)object);
            if ((long)byArray.length > l) {
                throw ErrorFactory.makeTDDataTruncation("TJ534", n, true, false, byArray.length, (int)l);
            }
            long l2 = fullContentMetadataItem.getMaxNumberOfCharacters();
            boolean bl = JDBC4Constants.isCharType(fullContentMetadataItem.getDataType());
            if (bl && (long)((String)object).length() > l2) {
                l = Encoder.encodeStringParameter(this.con, n, ((String)object).substring(0, (int)l2)).length;
                throw ErrorFactory.makeTDDataTruncation("TJ560", n, true, false, byArray.length, (int)l);
            }
        } else if (object instanceof TypedNull && fullContentMetadataItem.isNullable() == 78) {
            throw ErrorFactory.makeDriverJDBCException("TJ538", n);
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void initPacket(TDPacket tDPacket) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind((byte)5);
        tDPacket.setRequestNumber(this.con.getRequestNum());
    }

    private int initIndicData(TDPacket tDPacket, int n) throws SQLException {
        int n2 = ((Object[])this.batchedRows.get(0)).length + (this.paramMetaData != null ? 1 : 0);
        byte[] byArray = new byte[(n2 + 7) / 8];
        ParameterProperties.ParameterSet parameterSet = ParameterProperties.createParameterSetForIndicData(n2);
        int n3 = 0;
        boolean bl = true;
        IndicDataParcel indicDataParcel = null;
        Object[] objectArray = null;
        ResponseParcel responseParcel = new ResponseParcel(this.con);
        int n4 = responseParcel.toStream().limit();
        int n5 = 0;
        while (n < this.batchedRows.size()) {
            int n6;
            for (n6 = 0; n6 < byArray.length; ++n6) {
                byArray[n6] = 0;
            }
            n3 = byArray.length;
            objectArray = (Object[])this.batchedRows.get(n);
            for (n6 = 0; n6 < parameterSet.getNumberOfParamValues(); ++n6) {
                if (this.paramMetaData != null && n6 == objectArray.length) {
                    this.initPreparedParameter(parameterSet, this.m_listRowNumbers.get(n), n6 + 1, n + 1);
                } else {
                    this.initPreparedParameter(parameterSet, objectArray[n6], n6 + 1, n + 1);
                }
                n3 += parameterSet.getLength(n6 + 1);
                if (!parameterSet.isNullValue(n6 + 1)) continue;
                int n7 = (n6 + 8) / 8 - 1;
                byArray[n7] = (byte)(byArray[n7] | (byte)(1 << 7 - n6 % 8));
            }
            if (this.con.getConfigResponse().isLargeIndicDataSupported()) {
                indicDataParcel = new IndicDataParcel(n3, this.con, true);
            } else {
                n5 = n3 + Parcel.calculateHeaderLength(false);
                if (n5 > 65535) {
                    throw ErrorFactory.makeDriverJDBCException("TJ815", n + 1, n5, 65535);
                }
                indicDataParcel = new IndicDataParcel(n3, this.con, false);
            }
            indicDataParcel.setParameters(parameterSet);
            indicDataParcel.setNullIndicatorBits(byArray);
            n5 = indicDataParcel.toStream().limit();
            if (n5 > tDPacket.getBuffer().remaining() - n4) {
                if (!bl) break;
                throw ErrorFactory.makeDriverJDBCException("TJ421", n + 1, n5, tDPacket.getBuffer().remaining() - n4);
            }
            tDPacket.addParcel(indicDataParcel);
            if (bl) {
                bl = false;
            }
            ++n;
        }
        return n;
    }

    private void initPreparedParameter(ParameterProperties.ParameterSet parameterSet, Object object, int n, int n2) throws SQLException {
        boolean bl = false;
        Calendar calendar = null;
        int n3 = 0;
        if (object instanceof TypedNull) {
            object = ((TypedNull)object).getType();
            bl = true;
        }
        if (object instanceof ObjectWithCalendar) {
            calendar = ((ObjectWithCalendar)object).getCalendar();
            object = ((ObjectWithCalendar)object).getObject();
            n3 = 6;
        }
        boolean bl2 = true;
        if (object instanceof PeriodValue) {
            bl2 = ((PeriodValue)object).isVarByte();
            object = ((PeriodValue)object).getBytes();
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (this.isNumberDestination(n)) {
                byte[] byArray;
                int n4 = bigDecimal.scale();
                if (bigDecimal.compareTo(BigDecimal.valueOf(0L)) == 0) {
                    byArray = new byte[]{0};
                    n4 = 0;
                } else {
                    int n5;
                    int n6 = 40;
                    int n7 = bigDecimal.abs().unscaledValue().toString().length();
                    if (n7 > n6 && n7 - n6 - n4 > 0) {
                        int n8 = n7 - n6 - n4;
                        bigDecimal = bigDecimal.movePointLeft(n8);
                        bigDecimal = new BigDecimal(bigDecimal.toBigInteger());
                        bigDecimal = bigDecimal.movePointRight(n8);
                        n4 = 0;
                    } else if (n7 > n6 && n7 - n6 - n4 <= 0) {
                        n4 = n6 - (n7 - n4);
                        bigDecimal = bigDecimal.setScale(n4, 4);
                    }
                    String string = bigDecimal.unscaledValue().toString();
                    int n9 = n5 = string.length();
                    while (string.charAt(n9 - 1) == '0') {
                        --n9;
                    }
                    if (n9 < n5) {
                        n4 -= n5 - n9;
                        bigDecimal = new BigDecimal(string.substring(0, n9));
                    }
                    BigInteger bigInteger = bigDecimal.unscaledValue();
                    byte by = (byte)(bigInteger.toByteArray().length + 2);
                    byArray = new byte[by + 1];
                    byArray[0] = by;
                    ByteConverter.putShort(byArray, 1, (short)n4);
                    ByteConverter.bigIntToByteArray(bigInteger, byArray, 3);
                }
                parameterSet.setParameter(n, bigDecimal, byArray, 605, bl, -128, -128);
            } else {
                int n10 = 0;
                if (bigDecimal.compareTo(new BigDecimal(0)) != 0) {
                    n10 = bigDecimal.scale();
                    bigDecimal = bigDecimal.movePointRight(n10);
                }
                byte[] byArray = null;
                byArray = this.con.isLargeDecimalAndBigIntSupported() ? ByteConverter.bigIntToByteArray(bigDecimal.toBigInteger(), 16) : ByteConverter.putLong(bigDecimal.longValue());
                parameterSet.setParameter(n, object, byArray, 485, bl, this.maxDecimalPrecision, n10);
            }
        } else if (object instanceof Byte) {
            parameterSet.setParameter(n, object, ByteConverter.putByte((Byte)object), 757, bl, 0, 0);
        } else if (object instanceof byte[]) {
            byte[] byArray;
            byte[] byArray2 = (byte[])object;
            if (byArray2.length > 64000) {
                throw ErrorFactory.makeTDDataTruncation("TJ424", n, true, false, byArray2.length, 64000, n2);
            }
            byte[] byArray3 = byArray = bl2 ? new byte[byArray2.length + 2] : byArray2;
            if (bl2) {
                ByteConverter.putShort(byArray, 0, (short)byArray2.length);
                System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
            }
            parameterSet.setParameter(n, object, byArray, bl2 ? 689 : 693, bl, 0, 0);
        } else if (object instanceof Date) {
            int n11 = 0;
            if (!bl) {
                String string = ((Date)object).toString();
                n11 = (Integer.valueOf(string.substring(0, 4)) - 1900) * 10000 + Integer.valueOf(string.substring(5, 7)) * 100 + Integer.valueOf(string.substring(8, 10));
            }
            parameterSet.setParameter(n, object, ByteConverter.putInt(n11), 497, bl, 0, 0);
        } else if (object instanceof Double) {
            parameterSet.setParameter(n, object, ByteConverter.putDouble((Double)object), 481, bl, 0, 0);
        } else if (object instanceof Integer) {
            parameterSet.setParameter(n, object, ByteConverter.putInt((Integer)object), 497, bl, 0, 0);
        } else if (object instanceof Long) {
            parameterSet.setParameter(n, object, ByteConverter.putLong((Long)object), 601, bl, 0, 0);
        } else if (object instanceof Short) {
            parameterSet.setParameter(n, object, ByteConverter.putShort((Short)object), 501, bl, 0, 0);
        } else if (object instanceof String) {
            byte[] byArray = Encoder.encodeStringParameter(this.con, n, n2, (String)object);
            if (byArray.length > 64000) {
                throw ErrorFactory.makeTDDataTruncation("TJ410", n, true, false, byArray.length, 64000, n2);
            }
            byte[] byArray4 = new byte[byArray.length + 2];
            ByteConverter.putShort(byArray4, 0, (short)byArray.length);
            System.arraycopy(byArray, 0, byArray4, 2, byArray.length);
            parameterSet.setParameter(n, object, byArray4, 449, bl, 0, 0);
        } else if (object instanceof CompleteTimeValue) {
            int n12;
            CompleteTimeValue completeTimeValue = (CompleteTimeValue)object;
            String string = completeTimeValue.s;
            String string2 = "";
            if (completeTimeValue.cal != null) {
                string2 = string.substring(string.length() - 6);
                string = string.substring(0, string.length() - 6);
            }
            String string3 = "";
            if (string.length() > 8) {
                string3 = string.substring(8);
                string = string.substring(0, 8);
            }
            if ((n12 = this.getFractionalSecStrLen(n, this.con.getURLParameters().getTimeNano())) < string3.length()) {
                string3 = string3.substring(0, n12);
            } else if (string3.length() < n12) {
                string3 = string3 + ".000000000".substring(string3.length(), n12);
            }
            parameterSet.setParameter(n, completeTimeValue.ti, Encoder.encodeStringParameter(this.con, n, n2, string + string3 + string2), 453, bl, 0, 0);
        } else if (object instanceof Time) {
            int n13 = this.getFractionalSecStrLen(n, this.con.getURLParameters().getTimeNano());
            StringBuffer stringBuffer = new StringBuffer(8 + n13 + n3);
            if (!bl) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTimeInMillis(((Time)object).getTime());
                int n14 = gregorianCalendar.get(14);
                String string = String.valueOf(n14);
                if (n14 < 10) {
                    string = "00" + n14;
                } else if (n14 < 100) {
                    string = "0" + n14;
                }
                String string4 = ((Time)object).toString() + "." + string;
                int n15 = string4.length() > stringBuffer.capacity() - n3 ? stringBuffer.capacity() - n3 : string4.length();
                stringBuffer = stringBuffer.append(string4.toCharArray(), 0, n15);
                for (int i = n15; i < stringBuffer.capacity() - n3; ++i) {
                    stringBuffer = stringBuffer.append('0');
                }
                if (calendar != null) {
                    stringBuffer = stringBuffer.append(TDPreparedStatement.formatCalendarTimeZone(n, calendar));
                }
            } else {
                for (int i = 0; i < stringBuffer.capacity(); ++i) {
                    stringBuffer = stringBuffer.append(' ');
                }
            }
            parameterSet.setParameter(n, object, Encoder.encodeStringParameter(this.con, n, n2, stringBuffer.toString()), 453, bl, 0, 0);
        } else if (object instanceof Timestamp) {
            int n16 = this.getFractionalSecStrLen(n, this.con.getURLParameters().getTimestampNano());
            StringBuffer stringBuffer = new StringBuffer(19 + n16 + n3);
            if (!bl) {
                String string = ((Timestamp)object).toString();
                int n17 = string.length() > stringBuffer.capacity() - n3 ? stringBuffer.capacity() - n3 : string.length();
                stringBuffer = stringBuffer.append(string.toCharArray(), 0, n17);
                for (int i = n17; i < stringBuffer.capacity() - n3; ++i) {
                    stringBuffer = stringBuffer.append('0');
                }
                if (calendar != null) {
                    stringBuffer = stringBuffer.append(TDPreparedStatement.formatCalendarTimeZone(n, calendar));
                }
            } else {
                for (int i = 0; i < stringBuffer.capacity(); ++i) {
                    stringBuffer = stringBuffer.append(' ');
                }
            }
            parameterSet.setParameter(n, object, Encoder.encodeStringParameter(this.con, n, n2, stringBuffer.toString()), 453, bl, 0, 0);
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ417", String.valueOf(n), String.valueOf(n2), object.getClass().getName());
        }
    }

    private int getFractionalSecStrLen(int n, int n2) {
        FullContentMetadataItem fullContentMetadataItem;
        int n3 = this.paramMetaData == null ? (n2 < 1 ? 0 : n2 + 1) : ((fullContentMetadataItem = (FullContentMetadataItem)this.paramMetaData.get(n - 1)).getNumberOfFractionalDigits() < 1 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1);
        return n3;
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        ResponseParcel responseParcel = new ResponseParcel(this.con);
        responseParcel.setMaxMsgSize(65104);
        tDPacket.addParcel(responseParcel);
    }

    protected int bufferBatchedRows(TDPacket tDPacket, int n) throws SQLException {
        this.initPacket(tDPacket);
        n = this.initIndicData(tDPacket, n);
        this.initResp(tDPacket);
        tDPacket.toStream();
        return n;
    }

    protected void sendBatchedRows(TDPacket tDPacket) throws SQLException {
        tDPacket.getBuffer().writeStream(this.con.getIO());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveBatchedRowUpdateCounts(int n, int[] nArray) throws SQLException {
        TDPacket tDPacket = this.con.createPacket(1);
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(tDNetworkIOIF);
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
        tDPacket.initParcelFactory(this.con);
        Parcel parcel = null;
        block9: while ((parcel = tDPacket.nextParcel()) != null) {
            this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
            switch (parcel.getFlavor()) {
                case 8: {
                    SuccessParcel successParcel = (SuccessParcel)parcel;
                    int n2 = n;
                    while ((long)n2 < (long)n + successParcel.getActivityCount()) {
                        nArray[n2] = 1;
                        ++n2;
                    }
                    continue block9;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
                case 12: {
                    return;
                }
                default: {
                    this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                    throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
                }
            }
        }
        this.con.getLog().error("Did not receive an expected parcel from the database!");
        throw ErrorFactory.makeIoJDBCException("TJ420", "FastLoadPreparedStatement.receiveBatchedRowUpdateCounts", this.con.getIO(), null, this.con.getLog());
    }

    protected void shareWorkingRow(FastLoadPreparedStatement fastLoadPreparedStatement) {
        this.workingRow = fastLoadPreparedStatement.workingRow;
        this.workingRowColumn = fastLoadPreparedStatement.workingRowColumn;
        this.batchedRowsUsedForValidation = fastLoadPreparedStatement.batchedRowsUsedForValidation;
    }

    protected void setParameterMetaData(ArrayList arrayList) {
        this.paramMetaData = arrayList;
    }

    protected void addRowNumber(int n) {
        this.m_listRowNumbers.add(new Integer(n));
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        if (this.workingRowColumn.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ412");
        }
        if (this.workingRowColumn.length() != this.workingRowColumn.nextClearBit(0)) {
            throw ErrorFactory.makeDriverJDBCException("TJ414", this.workingRowColumn.nextClearBit(0) + 1);
        }
        Object[] objectArray = new Object[this.workingRowColumn.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.workingRow[i];
        }
        if (this.batchedRowsUsedForValidation.size() > 0) {
            Object[] objectArray2 = (Object[])this.batchedRowsUsedForValidation.get(0);
            if (objectArray.length != objectArray2.length) {
                throw ErrorFactory.makeDriverJDBCException("TJ413", objectArray2.length, objectArray.length);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                Object object2 = objectArray2[i];
                boolean bl = false;
                if (object2 instanceof TypedNull) {
                    object2 = ((TypedNull)object2).getType();
                }
                if (object2 instanceof CompleteTimeValue) {
                    object = (CompleteTimeValue)object2;
                    object2 = ((CompleteTimeValue)object).ti;
                    boolean bl2 = bl = ((CompleteTimeValue)object).cal != null;
                }
                if (object2 instanceof ObjectWithCalendar) {
                    object2 = ((ObjectWithCalendar)object2).getObject();
                    bl = true;
                }
                object = objectArray[i];
                boolean bl3 = false;
                if (object instanceof TypedNull) {
                    object = ((TypedNull)object).getType();
                }
                if (object instanceof CompleteTimeValue) {
                    CompleteTimeValue completeTimeValue = (CompleteTimeValue)object;
                    object = completeTimeValue.ti;
                    boolean bl4 = bl3 = completeTimeValue.cal != null;
                }
                if (object instanceof ObjectWithCalendar) {
                    object = ((ObjectWithCalendar)object).getObject();
                    bl3 = true;
                }
                if (!object.getClass().isInstance(object2)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ415", String.valueOf(i + 1), object2.getClass().getName(), object.getClass().getName());
                }
                if (object2 instanceof Time && bl3 != bl) {
                    throw ErrorFactory.makeDriverJDBCException("TJ450", i + 1);
                }
                if (object2 instanceof Timestamp && bl3 != bl) {
                    throw ErrorFactory.makeDriverJDBCException("TJ451", i + 1);
                }
                if (!(object2 instanceof BigDecimal) || this.isNumberDestination(i + 1) || ((BigDecimal)object2).scale() == ((BigDecimal)object).scale()) continue;
                throw ErrorFactory.makeDriverJDBCException("TJ423", i + 1, ((BigDecimal)object2).scale(), ((BigDecimal)object).scale());
            }
        }
        this.batchedRows.add(objectArray);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        for (int i = 0; i < this.workingRowColumn.length(); ++i) {
            this.workingRow[i] = null;
        }
        this.workingRowColumn.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            if (this.isNumberDestination(n)) {
                this.setNull(n, 2);
                return;
            }
            this.abortIfClosed();
            this.abortIfIndexNotValid(n);
            throw ErrorFactory.makeDriverJDBCException("TJ432", n);
        }
        this.setObject(n, bigDecimal);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, new Byte(by));
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -3);
            return;
        }
        this.setObject(n, byArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (calendar != null) {
            date = TDResultSet.convertDateWithTimeZoneToGMT(n, date, calendar);
        }
        this.setObject(n, date);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, new Double(d));
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, Double.valueOf(Float.toString(f)));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, new Integer(n2));
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setObject(n, new Long(l));
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        Object object;
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        switch (n2) {
            case -5: {
                object = new TypedNull(new Long(0L));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = new TypedNull(new byte[0]);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = new TypedNull("");
                break;
            }
            case 91: {
                object = new TypedNull(new Date(0L));
                break;
            }
            case 2: 
            case 3: {
                if (this.isNumberDestination(n)) {
                    object = new TypedNull(BigDecimal.valueOf(0L));
                    break;
                }
                throw ErrorFactory.makeDriverJDBCException("TJ449", n);
            }
            case 6: 
            case 7: 
            case 8: {
                object = new TypedNull(new Double(0.0));
                break;
            }
            case 4: {
                object = new TypedNull(new Integer(0));
                break;
            }
            case 5: {
                object = new TypedNull(new Short(0));
                break;
            }
            case 92: {
                object = new TypedNull(new Time(0L));
                break;
            }
            case 93: {
                object = new TypedNull(new Timestamp(0L));
                break;
            }
            case -6: {
                object = new TypedNull(new Byte(0));
                break;
            }
            case 2002: {
                StructAttributes structAttributes = new StructAttributes(this, this.paramMetaData, n, null, null);
                structAttributes.setNull();
                object = structAttributes.getObject();
                break;
            }
            case -7: 
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ429", n, n2);
            }
        }
        this.setObject(n, object);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        Object object2;
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ425", n);
        }
        Object object3 = object;
        if (object instanceof Object[] && ((Object[])(object2 = (Object[])object)).length == 3 && object2[0] instanceof Time && (object2[1] == null || object2[1] instanceof Calendar) && object2[2] instanceof String) {
            object3 = object2[0];
            object = new CompleteTimeValue((Time)object2[0], (Calendar)object2[1], (String)object2[2]);
        }
        if (object3 instanceof TypedNull) {
            object3 = ((TypedNull)object3).getType();
        }
        if (object3 instanceof ObjectWithCalendar) {
            object3 = ((ObjectWithCalendar)object3).getObject();
        }
        if (object3 instanceof Time && this.con.getURLParameters().getTimeNano() < 0 && this.paramMetaData == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ452", n);
        }
        if (object3 instanceof Timestamp && this.con.getURLParameters().getTimestampNano() < 0 && this.paramMetaData == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ453", n);
        }
        if (object instanceof BigDecimal) {
            if (!this.isNumberDestination(n)) {
                int n2;
                object2 = (BigDecimal)object;
                int n3 = ((BigDecimal)object2).scale();
                if (n3 < 0) {
                    object2 = ((BigDecimal)object2).movePointRight(0);
                    n3 = ((BigDecimal)object2).scale();
                }
                if ((n2 = ComUtil.getSignificantDigits((BigDecimal)object2) + n3) > this.maxDecimalPrecision) {
                    throw ErrorFactory.makeTDDataTruncation("TJ422", n, true, false, n2, this.maxDecimalPrecision);
                }
            }
        } else if (object instanceof Float) {
            object = new Double(Double.valueOf(object.toString()));
        } else if (object instanceof SQLData) {
            object2 = this.con.constructSQLOutput(this, this.paramMetaData, n, object.getClass().getName(), ((SQLData)object).getSQLTypeName());
            ((SQLData)object).writeSQL((SQLOutput)object2);
            object = ((FastLoadSQLOutput)object2).getObject();
        } else if (object instanceof Struct) {
            object2 = new StructAttributes(this, this.paramMetaData, n, object.getClass().getName(), ((Struct)object).getSQLTypeName());
            ((StructAttributes)object2).setStruct(((Struct)object).getAttributes());
            object = ((StructAttributes)object2).getObject();
        } else if (!(object instanceof Byte || object instanceof byte[] || object instanceof Date || object instanceof Double || object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof String || object instanceof Time || object instanceof Timestamp || object instanceof TypedNull || object instanceof CompleteTimeValue || object instanceof ObjectWithCalendar)) {
            throw ErrorFactory.makeDriverJDBCException("TJ426", String.valueOf(n), object.getClass().getName());
        }
        this.abortIfParameterMetaDataConflicts(n, object);
        this.workingRow[n - 1] = object;
        this.workingRowColumn.set(n - 1);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -5: {
                if (object instanceof Long) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof byte[]) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof String) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 91: {
                if (object instanceof Date) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 2: 
            case 3: {
                if (object instanceof BigDecimal) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Double || object instanceof Float) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 4: {
                if (object instanceof Integer) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 5: {
                if (object instanceof Short) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 92: {
                if (object instanceof Time) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 93: {
                if (object instanceof Timestamp) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -6: {
                if (object instanceof Byte) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 2002: {
                if (object instanceof SQLData || object instanceof Struct) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -7: 
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ429", n, n2);
            }
        }
        this.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (!(object != null || n2 != 3 && n2 != 2 || this.isNumberDestination(n))) {
            if (n3 < 0 || n3 > this.maxDecimalPrecision) {
                throw ErrorFactory.makeDriverJDBCException("TJ431", n, n3, this.maxDecimalPrecision);
            }
            this.setObject(n, new TypedNull(new BigDecimal("0").setScale(n3)));
            return;
        }
        if (object instanceof BigDecimal && !this.isNumberDestination(n)) {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n4 = bigDecimal.scale();
            if (n4 < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n4 = bigDecimal.scale();
            }
            if (n4 != n3) {
                throw ErrorFactory.makeDriverJDBCException("TJ430", n, n4, n3);
            }
        }
        this.setObject(n, object, n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, new Short(s));
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 12);
            return;
        }
        this.setObject(n, string);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null && calendar == null) {
            this.setNull(n, 92);
            return;
        }
        if (time == null && calendar != null) {
            this.setObject(n, new TypedNull(new ObjectWithCalendar(new Time(0L), calendar)));
            return;
        }
        if (time != null && calendar != null) {
            this.setObject(n, new ObjectWithCalendar(time, calendar));
            return;
        }
        this.setObject(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null && calendar == null) {
            this.setNull(n, 93);
            return;
        }
        if (timestamp == null && calendar != null) {
            this.setObject(n, new TypedNull(new ObjectWithCalendar(new Timestamp(0L), calendar)));
            return;
        }
        if (timestamp != null && calendar != null) {
            this.setObject(n, new ObjectWithCalendar(timestamp, calendar));
            return;
        }
        this.setObject(n, timestamp);
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        this.batchedRows.clear();
        this.m_listRowNumbers.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void close() throws SQLException {
        this.workingRow = null;
        this.workingRowColumn = null;
        this.batchedRows = null;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Object object;
        this.abortIfClosed();
        if (this.batchedRows.size() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ416");
        }
        SQLException sQLException = null;
        int n = 0;
        int[] nArray = new int[this.batchedRows.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = -3;
        }
        try {
            object = this.con.createPacket(2);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            do {
                SQLException sQLException2;
                bl3 = false;
                n4 = n2;
                n2 = n3;
                if (bl) {
                    bl = false;
                    try {
                        n2 = this.bufferBatchedRows((TDPacket)object, n2);
                        this.sendBatchedRows((TDPacket)object);
                        if (!bl2) {
                            bl2 = true;
                        }
                    }
                    catch (SQLException sQLException3) {
                        sQLException2 = ErrorFactory.makeDriverJDBCException("TJ522");
                        sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                        sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException3);
                    }
                }
                try {
                    if (n2 < this.batchedRows.size()) {
                        n3 = this.bufferBatchedRows((TDPacket)object, n2);
                    }
                }
                catch (SQLException sQLException4) {
                    sQLException2 = ErrorFactory.makeDriverJDBCException("TJ523");
                    sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException4);
                }
                try {
                    if (!bl2) continue;
                    this.receiveBatchedRowUpdateCounts(n4, nArray);
                    if (n2 < n3) {
                        this.sendBatchedRows((TDPacket)object);
                        if (!bl3) {
                            bl3 = true;
                        }
                    }
                    for (int i = n4; i < n2; ++i) {
                        if (nArray[i] == 1) continue;
                        ++n;
                    }
                }
                catch (SQLException sQLException5) {
                    sQLException2 = ErrorFactory.makeDriverJDBCException("TJ524");
                    sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
                    sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException5);
                }
            } while (bl2 = bl3);
            if (n != 0) {
                SQLException sQLException6 = ErrorFactory.makeDriverJDBCException("TJ563", String.valueOf(n));
                sQLException = FastLoadPreparedStatement.chainSQLExceptions(sQLException, sQLException6);
            }
        }
        finally {
            this.batchedRows.clear();
        }
        if (sQLException != null) {
            object = ErrorFactory.makeBatchUpdateException("TJ525", nArray);
            sQLException = this.con.flatten(sQLException);
            ((SQLException)object).setNextException(sQLException);
            object = (BatchUpdateException)this.con.flatten((SQLException)object);
            ((Throwable)object).initCause(sQLException);
            throw object;
        }
        return nArray;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.workingRow == null || this.workingRowColumn == null || this.batchedRows == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,NClob)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private static class StructAttributes {
        private int m_parameterIndex;
        private String m_appName;
        private String m_sqlTypeName;
        private PeriodValue m_periodData;
        private int[] m_sqlDataType;
        private short m_serverDataType;

        public StructAttributes(FastLoadPreparedStatement fastLoadPreparedStatement, ArrayList arrayList, int n, String string, String string2) throws SQLException {
            this.m_parameterIndex = n;
            this.m_appName = string;
            this.m_sqlTypeName = string2;
            AttributeMetaData attributeMetaData = new AttributeMetaData(fastLoadPreparedStatement, arrayList, n, string, string2);
            this.m_periodData = new PeriodValue(attributeMetaData);
            this.m_sqlDataType = attributeMetaData.getSQLDataType();
            this.m_serverDataType = attributeMetaData.getServerDataType();
        }

        public Object getObject() {
            if (this.m_periodData.isNull()) {
                return new TypedNull(this.m_periodData);
            }
            return this.m_periodData;
        }

        public void setNull() throws SQLException {
            if (this.m_serverDataType == 832) {
                this.m_periodData.setPeriodDate(this.m_parameterIndex, null, null);
            } else if (this.m_serverDataType == 844 || this.m_serverDataType == 848) {
                this.m_periodData.setPeriodTimestamp(this.m_parameterIndex, null, null);
            } else if (this.m_serverDataType == 836 || this.m_serverDataType == 840) {
                this.m_periodData.setPeriodTime(this.m_parameterIndex, null, null);
            } else {
                throw new IllegalArgumentException("Unexpected serverDataType=" + this.m_serverDataType + " at parameterIndex=" + this.m_parameterIndex);
            }
        }

        public void setStruct(Object[] objectArray) throws SQLException {
            this.setStruct(objectArray, this.m_sqlDataType, this.m_appName, this.m_sqlTypeName);
        }

        private void setStruct(Object[] objectArray, int[] nArray, String string, String string2) throws SQLException {
            if (objectArray == null) {
                this.setNull();
            } else {
                String string3 = string + ".getAttributes";
                if (objectArray.length != nArray.length) {
                    throw ErrorFactory.makeDriverJDBCException("TJ790", string3, String.valueOf(objectArray.length), String.valueOf(nArray.length), string2);
                }
                Calendar calendar = null;
                if (nArray[nArray.length - 1] == 1111) {
                    if (objectArray[nArray.length - 1] != null && !(objectArray[nArray.length - 1] instanceof Calendar)) {
                        throw ErrorFactory.makeDriverJDBCException("TJ791", string2, String.valueOf(nArray.length - 1), objectArray[nArray.length - 1].getClass().getName(), "java.util.Calendar", JDBC4Constants.getTDTypeName(this.m_serverDataType));
                    }
                    if (objectArray[nArray.length - 1] != null && objectArray[nArray.length - 1] instanceof Calendar) {
                        calendar = (Calendar)objectArray[nArray.length - 1];
                    }
                }
                for (int i = 0; i < objectArray.length && nArray[i] != 1111; ++i) {
                    if (objectArray[i] == null) {
                        this.setNull();
                        continue;
                    }
                    if (objectArray[i] instanceof Date) {
                        if (nArray[i] != 91) {
                            throw ErrorFactory.makeDriverJDBCException("TJ791", string2, String.valueOf(i), objectArray[i].getClass().getName(), JDBC4Constants.getJavaClassNameForSqlType(nArray[i]), JDBC4Constants.getTDTypeName(this.m_serverDataType));
                        }
                        this.m_periodData.setPeriodDate(this.m_parameterIndex, (Date)objectArray[i], calendar);
                        continue;
                    }
                    if (objectArray[i] instanceof Time) {
                        if (nArray[i] != 92) {
                            throw ErrorFactory.makeDriverJDBCException("TJ791", string2, String.valueOf(i), objectArray[i].getClass().getName(), JDBC4Constants.getJavaClassNameForSqlType(nArray[i]), JDBC4Constants.getTDTypeName(this.m_serverDataType));
                        }
                        this.m_periodData.setPeriodTime(this.m_parameterIndex, (Time)objectArray[i], calendar);
                        continue;
                    }
                    if (objectArray[i] instanceof Timestamp) {
                        if (nArray[i] != 93) {
                            throw ErrorFactory.makeDriverJDBCException("TJ791", string2, String.valueOf(i), objectArray[i].getClass().getName(), JDBC4Constants.getJavaClassNameForSqlType(nArray[i]), JDBC4Constants.getTDTypeName(this.m_serverDataType));
                        }
                        this.m_periodData.setPeriodTimestamp(this.m_parameterIndex, (Timestamp)objectArray[i], calendar);
                        continue;
                    }
                    if (objectArray[i] instanceof Struct) {
                        this.setStruct(((Struct)objectArray[i]).getAttributes(), new int[]{nArray[i], 1111}, objectArray[i].getClass().getName(), ((Struct)objectArray[i]).getSQLTypeName());
                        continue;
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ792", string2, String.valueOf(i), objectArray[i].getClass().getName(), JDBC4Constants.getTDTypeName(this.m_serverDataType));
                }
            }
        }
    }

    protected static class AttributeMetaData {
        private int m_scale;
        private int[] m_sqlDataType;
        private short m_serverDataType;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public AttributeMetaData(FastLoadPreparedStatement fastLoadPreparedStatement, ArrayList arrayList, int n, String string, String string2) throws SQLException {
            if (fastLoadPreparedStatement.batchedRowsUsedForValidation.size() == 0) {
                if (arrayList == null) {
                    if (string == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ788", n);
                    }
                    String string3 = string + ".getSQLTypeName";
                    if (string2 == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ743", string3);
                    }
                    String string4 = string2.trim().toUpperCase();
                    if (string4.startsWith("PERIOD(DATE")) {
                        this.m_scale = 0;
                        this.m_sqlDataType = new int[2];
                        Arrays.fill(this.m_sqlDataType, 91);
                        this.m_serverDataType = (short)832;
                        return;
                    } else if (string4.startsWith("PERIOD(TIMESTAMP")) {
                        int n2 = ((FastLoadConnection)fastLoadPreparedStatement.getConnection()).getURLParameters().getTimestampNano();
                        if (n2 < 0) {
                            throw ErrorFactory.makeDriverJDBCException("TJ453", n);
                        }
                        this.m_scale = n2 < 1 ? 0 : n2;
                        this.m_sqlDataType = new int[2];
                        Arrays.fill(this.m_sqlDataType, 93);
                        this.m_serverDataType = string4.endsWith("ZONE)") ? (short)848 : (short)844;
                        return;
                    } else {
                        if (!string4.startsWith("PERIOD(TIME")) throw ErrorFactory.makeDriverJDBCException("TJ744", string3, string2);
                        int n3 = ((FastLoadConnection)fastLoadPreparedStatement.getConnection()).getURLParameters().getTimeNano();
                        if (n3 < 0) {
                            throw ErrorFactory.makeDriverJDBCException("TJ452", n);
                        }
                        this.m_scale = n3 < 1 ? 0 : n3;
                        this.m_sqlDataType = new int[2];
                        Arrays.fill(this.m_sqlDataType, 92);
                        this.m_serverDataType = string4.endsWith("ZONE)") ? (short)840 : (short)836;
                    }
                    return;
                } else {
                    FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)arrayList.get(n - 1);
                    this.m_scale = fullContentMetadataItem.getNumberOfFractionalDigits() < 1 ? (short)0 : fullContentMetadataItem.getNumberOfFractionalDigits();
                    ArrayList arrayList2 = fullContentMetadataItem.getAttributeItemList();
                    this.m_sqlDataType = new int[arrayList2.size()];
                    for (int i = 0; i < this.m_sqlDataType.length; ++i) {
                        this.m_sqlDataType[i] = JDBC4Constants.getJavaSQLType(((FullContentMetadataItem)arrayList2.get(i)).getDataType());
                    }
                    this.m_serverDataType = JDBC4Constants.getTDBasicType(fullContentMetadataItem.getServerDataType());
                }
                return;
            } else {
                Object[] objectArray = (Object[])fastLoadPreparedStatement.batchedRowsUsedForValidation.get(0);
                Object object = objectArray[n - 1];
                if (object instanceof TypedNull) {
                    object = ((TypedNull)object).getType();
                }
                if (object instanceof ObjectWithCalendar) {
                    object = ((ObjectWithCalendar)object).getObject();
                }
                if (object instanceof PeriodValue) {
                    this.m_sqlDataType = ((PeriodValue)object).getAttributeMetaData().getSQLDataType();
                    this.m_serverDataType = ((PeriodValue)object).getAttributeMetaData().getServerDataType();
                    this.m_scale = ((PeriodValue)object).getAttributeMetaData().getScale();
                    return;
                } else {
                    if (string != null) throw ErrorFactory.makeDriverJDBCException("TJ415", String.valueOf(n), object.getClass().getName(), string);
                    throw ErrorFactory.makeDriverJDBCException("TJ789", String.valueOf(n), object.getClass().getName());
                }
            }
        }

        public int[] getSQLDataType() {
            return this.m_sqlDataType;
        }

        public short getServerDataType() {
            return this.m_serverDataType;
        }

        public int getScale() {
            return this.m_scale;
        }
    }

    protected static class PeriodValue {
        private AttributeMetaData m_attrMetaData;
        private int m_attributeIndex = 0;
        private int m_offset = 0;
        private byte[] m_aby = null;
        private boolean m_isNull = false;
        private boolean m_isVarByte = false;
        private Calendar m_workingCal = new GregorianCalendar();

        public PeriodValue(AttributeMetaData attributeMetaData) {
            this.m_attrMetaData = attributeMetaData;
        }

        public boolean isNull() {
            return this.m_isNull;
        }

        public boolean isVarByte() {
            return this.m_isVarByte;
        }

        public byte[] getBytes() {
            return this.m_aby;
        }

        public AttributeMetaData getAttributeMetaData() {
            return this.m_attrMetaData;
        }

        public void setPeriodDate(int n, Date date, Calendar calendar) throws SQLException {
            if (this.m_attributeIndex == 0) {
                this.m_aby = new byte[8];
                this.m_isVarByte = false;
            } else if (this.m_attributeIndex >= this.m_attrMetaData.getSQLDataType().length) {
                throw new IllegalArgumentException("Unexpected attributeIndex " + this.m_attributeIndex + " >= " + this.m_attrMetaData.getSQLDataType().length + " at parameterIndex " + n);
            }
            if (date != null && !this.m_isNull) {
                if (this.m_attrMetaData.getSQLDataType()[this.m_attributeIndex] != 91) {
                    throw new IllegalArgumentException("Unexpected sqlDataType=" + this.m_attrMetaData.getSQLDataType()[this.m_attributeIndex] + " at attributeIndex=" + this.m_attributeIndex + " of parameterIndex=" + n);
                }
                if (calendar != null) {
                    TDResultSet.validateCalendarTimeZone(n, calendar);
                    date.setTime(date.getTime() - (long)calendar.getTimeZone().getRawOffset());
                }
                this.m_workingCal.setTimeInMillis(date.getTime());
                int n2 = this.m_workingCal.get(1);
                int n3 = this.m_workingCal.get(2) + 1;
                int n4 = this.m_workingCal.get(5);
                ByteConverter.putInt(this.m_aby, this.m_offset, (n2 - 1900) * 10000 + n3 * 100 + n4);
            } else if (!this.m_isNull) {
                this.m_isNull = true;
            }
            this.m_offset += this.m_aby.length / 2;
            ++this.m_attributeIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setPeriodTime(int n, Time time, Calendar calendar) throws SQLException {
            short s = this.m_attrMetaData.getServerDataType();
            if (this.m_attributeIndex == 0) {
                this.m_isVarByte = false;
                if (s == 836) {
                    this.m_aby = new byte[12];
                } else {
                    if (s != 840) throw new IllegalArgumentException("Unexpected serverDataType=" + s + " at attributeIndex=" + this.m_attributeIndex + " of parameterIndex=" + n);
                    this.m_aby = new byte[16];
                }
            } else if (this.m_attributeIndex >= this.m_attrMetaData.getSQLDataType().length) {
                throw new IllegalArgumentException("Unexpected attributeIndex " + this.m_attributeIndex + " >= " + this.m_attrMetaData.getSQLDataType().length + " at parameterIndex " + n);
            }
            if (time != null && !this.m_isNull) {
                if (this.m_attrMetaData.getSQLDataType()[this.m_attributeIndex] != 92) {
                    throw new IllegalArgumentException("Unexpected sqlDataType=" + this.m_attrMetaData.getSQLDataType()[this.m_attributeIndex] + " at attributeIndex=" + this.m_attributeIndex + " of parameterIndex=" + n);
                }
                if (calendar != null && s == 836) {
                    TDResultSet.validateCalendarTimeZone(n, calendar);
                    time.setTime(time.getTime() - (long)calendar.getTimeZone().getRawOffset());
                }
                this.m_workingCal.setTimeInMillis(time.getTime());
                int n2 = this.m_workingCal.get(11);
                int n3 = this.m_workingCal.get(12);
                int n4 = this.m_workingCal.get(13);
                int n5 = this.m_workingCal.get(14);
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(n4) + "." + String.valueOf(n5)).setScale(this.m_attrMetaData.getScale(), 1).movePointRight(6);
                ByteConverter.bigIntToByteArray(bigDecimal.toBigInteger(), this.m_aby, this.m_offset, 4);
                this.m_aby[this.m_offset + 4] = (byte)n2;
                this.m_aby[this.m_offset + 5] = (byte)n3;
                if (s == 840) {
                    this.m_aby[this.m_offset + 6] = 16;
                    if (calendar != null) {
                        TDResultSet.validateCalendarTimeZone(n, calendar);
                        int n6 = calendar.getTimeZone().getRawOffset() / 60000;
                        int n7 = n6 % 60 * (n6 < 0 ? -1 : 1);
                        int n8 = n6 / 60 * (n6 < 0 ? -1 : 1);
                        if (n6 >= 0) {
                            n8 += 16;
                        }
                        this.m_aby[this.m_offset + 6] = (byte)n8;
                        this.m_aby[this.m_offset + 7] = (byte)n7;
                    }
                }
            } else if (!this.m_isNull) {
                this.m_isNull = true;
            }
            this.m_offset += this.m_aby.length / 2;
            ++this.m_attributeIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setPeriodTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
            short s = this.m_attrMetaData.getServerDataType();
            if (this.m_attributeIndex == 0) {
                this.m_isVarByte = true;
                if (s == 844) {
                    this.m_aby = new byte[20];
                } else {
                    if (s != 848) throw new IllegalArgumentException("Unexpected serverDataType=" + s + " at attributeIndex=" + this.m_attributeIndex + " of parameterIndex=" + n);
                    this.m_aby = new byte[24];
                }
            } else if (this.m_attributeIndex >= this.m_attrMetaData.getSQLDataType().length) {
                throw new IllegalArgumentException("Unexpected attributeIndex " + this.m_attributeIndex + " >= " + this.m_attrMetaData.getSQLDataType().length + " at parameterIndex " + n);
            }
            if (timestamp != null && !this.m_isNull) {
                if (this.m_attrMetaData.getSQLDataType()[this.m_attributeIndex] != 93) {
                    throw new IllegalArgumentException("Unexpected sqlDataType=" + this.m_attrMetaData.getSQLDataType()[this.m_attributeIndex] + " at attributeIndex=" + this.m_attributeIndex + " of parameterIndex=" + n);
                }
                int n2 = timestamp.getNanos();
                if (calendar != null && s == 844) {
                    TDResultSet.validateCalendarTimeZone(n, calendar);
                    timestamp.setTime(timestamp.getTime() - (long)calendar.getTimeZone().getRawOffset());
                }
                this.m_workingCal.setTimeInMillis(timestamp.getTime());
                int n3 = this.m_workingCal.get(1);
                int n4 = this.m_workingCal.get(2) + 1;
                int n5 = this.m_workingCal.get(5);
                int n6 = this.m_workingCal.get(11);
                int n7 = this.m_workingCal.get(12);
                int n8 = this.m_workingCal.get(13);
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(n8) + "." + String.valueOf(n2)).setScale(this.m_attrMetaData.getScale(), 1).movePointRight(6);
                ByteConverter.bigIntToByteArray(bigDecimal.toBigInteger(), this.m_aby, this.m_offset, 4);
                ByteConverter.putShort(this.m_aby, this.m_offset + 4, (short)n3);
                this.m_aby[this.m_offset + 6] = (byte)n4;
                this.m_aby[this.m_offset + 7] = (byte)n5;
                this.m_aby[this.m_offset + 8] = (byte)n6;
                this.m_aby[this.m_offset + 9] = (byte)n7;
                if (s == 848) {
                    this.m_aby[this.m_offset + 10] = 16;
                    if (calendar != null) {
                        TDResultSet.validateCalendarTimeZone(n, calendar);
                        int n9 = calendar.getTimeZone().getRawOffset() / 60000;
                        int n10 = n9 % 60 * (n9 < 0 ? -1 : 1);
                        int n11 = n9 / 60 * (n9 < 0 ? -1 : 1);
                        if (n9 >= 0) {
                            n11 += 16;
                        }
                        this.m_aby[this.m_offset + 10] = (byte)n11;
                        this.m_aby[this.m_offset + 11] = (byte)n10;
                    }
                }
            } else if (!this.m_isNull) {
                this.m_isNull = true;
            }
            this.m_offset += this.m_aby.length / 2;
            ++this.m_attributeIndex;
        }
    }

    private static class ObjectWithCalendar {
        private Object obj;
        private Calendar cal;

        public ObjectWithCalendar(Object object, Calendar calendar) {
            this.obj = object;
            this.cal = calendar;
        }

        public Object getObject() {
            return this.obj;
        }

        public Calendar getCalendar() {
            return this.cal;
        }
    }

    private static class CompleteTimeValue {
        public Time ti;
        public Calendar cal;
        public String s;

        public CompleteTimeValue(Time time, Calendar calendar, String string) {
            this.ti = time;
            this.cal = calendar;
            this.s = string;
        }
    }

    protected static class TypedNull {
        private Object type;

        public TypedNull(Object object) {
            this.type = object;
        }

        public Object getType() {
            return this.type;
        }
    }
}

