/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERUniversalTagOctets;
import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import java.io.UnsupportedEncodingException;

class DERUTF8String
extends DERASN1Type {
    private static final TdgssLogger logger = TdgssLoggingManager.getInstance().getLogger();
    private String value;

    DERUTF8String(String string) {
        this.value = string;
        this.octets = DERUTF8String.calcOctets(this.value);
    }

    DERUTF8String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    DERUTF8String(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    DERUTF8String(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    DERUTF8String(byte[] byArray, int n, int n2, boolean bl) {
        this.parse(byArray, n, n2, bl);
    }

    @Override
    protected void parse(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new DERException("Illegal values are passed.");
        }
        if (bl) {
            this.octets = new byte[n2];
            System.arraycopy(byArray, n, this.octets, 0, n2);
        } else {
            super.parseExplicitOctets(byArray, n);
        }
        this.value = this.getValueOf(this.octets);
    }

    @Override
    byte[] getUniveralTagOctets() {
        return DERUniversalTagOctets.UTF8_STRING;
    }

    private static byte[] calcOctets(String string) {
        byte[] byArray = null;
        if (string == null) {
            return byArray;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException.getMessage());
            throw new IllegalStateException();
        }
        return byArray;
    }

    private final String getValueOf(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException.getMessage());
            throw new IllegalStateException();
        }
        return string;
    }

    String getValue() {
        return this.value;
    }

    @Override
    protected boolean isConstructed() {
        return false;
    }
}

