/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.parcel.BigKeepResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.KeepResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.RowPositionParcel;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import java.sql.SQLException;

public class StatementContinueState
extends SendState {
    private StatementReceiveState receiveState;
    private long desiredRowNumber = -1L;
    private int desiredStatementNumber = 0;

    public StatementContinueState(StatementController statementController, StatementReceiveState statementReceiveState) {
        super(statementController);
        this.receiveState = statementReceiveState;
        this.log.debug("StatementContinueState constructor this=" + this);
    }

    public void setDesiredRowNumber(long l) {
        this.log.debug("StatementContinueState.setDesiredRowNumber old=" + this.desiredRowNumber + " new=" + l + " this=" + this);
        this.desiredRowNumber = l;
    }

    public void setDesiredStatementNumber(int n) {
        this.log.debug("StatementContinueState.setDesiredStatementNumber old=" + this.desiredStatementNumber + " new=" + n + " this=" + this);
        this.desiredStatementNumber = n;
    }

    @Override
    public TDParcelState action() throws SQLException {
        this.log.debug("StatementContinueState.action this=" + this);
        this.receiveState.setReturnState(null);
        this.initPacket();
        this.initAdditionalParcel();
        this.initFetchRowCountParcel(this.receiveState);
        this.initRsp();
        this.initControlData();
        this.sendPacket();
        return this.receiveState;
    }

    protected void initPacket() throws SQLException {
        this.initializePacket(1);
        this.packet.setLANKind((byte)6);
        this.packet.setRequestNumber(this.receiveState.getRequestNum());
    }

    protected void initAdditionalParcel() throws SQLException {
        if (this.desiredRowNumber != -1L) {
            this.packet.addParcel(new RowPositionParcel((short)this.desiredStatementNumber, this.desiredRowNumber, this.controller.getSession()));
        }
    }

    protected void initRsp() throws SQLException {
        ResponseParcel responseParcel;
        if (this.controller.getSession().areAPHResponsesSupported()) {
            responseParcel = this.controller.getStatement().useKeepResponse() ? new BigKeepResponseParcel(this.controller.getSession()) : new BigResponseParcel(this.controller.getSession());
            responseParcel.setMaxMsgSize(this.controller.getSession().getMaxMessageSize(false, false));
        } else {
            responseParcel = this.controller.getStatement().useKeepResponse() ? new KeepResponseParcel(this.controller.getSession()) : new ResponseParcel(this.controller.getSession());
            responseParcel.setMaxMsgSize(65104);
        }
        this.packet.addParcel(responseParcel);
    }

    public StatementReceiveState getReceiveState() {
        return this.receiveState;
    }
}

