/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.LanHeader;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ParcelFactory;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import java.sql.SQLException;

public class TDPacket {
    private LanHeader lanHeader = new LanHeader();
    private TDPacketStream buffer;
    private ParcelFactory parcelFactory;

    public TDPacket(int n) throws SQLException {
        this.buffer = new TDPacketStream(n);
    }

    public void setBuffer(TDPacketStream tDPacketStream) {
        this.buffer = tDPacketStream;
    }

    public TDPacketStream getBuffer() {
        return this.buffer;
    }

    public void newLanHeader() throws SQLException {
        this.lanHeader = new LanHeader();
    }

    public void addToMsgLength(int n) throws SQLException {
        this.lanHeader.addToMsgLength(n);
    }

    public void setInitParcelPosition() throws SQLException {
        this.buffer.position(52);
    }

    public void addParcel(Parcel parcel) throws SQLException {
        this.buffer.putStream(parcel.toStream());
        int n = parcel.getLength();
        this.lanHeader.addToMsgLength(n);
    }

    public void initParcelFactory(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        this.parcelFactory = new ParcelFactory(genericTeradataConnection);
        this.lanHeader = new LanHeader(this.buffer);
        this.setInitParcelPosition();
        this.parcelFactory.setTDPacket(this);
    }

    public void setParcelFactoryPrepInfo(PrepInfoParcel prepInfoParcel) {
        this.parcelFactory.setPrepInfo(prepInfoParcel);
    }

    public PrepInfoParcel getParcelFactoryPrepInfo() {
        return this.parcelFactory.getPrepInfo();
    }

    public Parcel nextParcel() throws SQLException {
        return this.parcelFactory.nextParcel();
    }

    public Parcel scanForEndParcel(boolean bl) throws SQLException {
        return this.parcelFactory.scanForEndStatementParcel(bl);
    }

    public int nextParcelPeek() throws SQLException {
        return this.parcelFactory.nextParcelPeek();
    }

    public int getCurrentPosition() {
        return this.parcelFactory.getCurrentPosition();
    }

    public void skipParcel(int n) {
        this.parcelFactory.skipParcel(n);
    }

    public TDPacketStream toStream() throws SQLException {
        this.buffer.position(0);
        this.buffer.putStream(this.lanHeader.toStream());
        this.buffer.position(0);
        this.buffer.limit(52 + this.lanHeader.getMsgLength());
        return this.buffer;
    }

    public int getLanMsgLength() {
        return this.lanHeader.getMsgLength();
    }

    public int getLANSessionNumber() {
        return this.lanHeader.getSessionNo();
    }

    public void setLANClass(byte by) throws SQLException {
        this.lanHeader.setMsgType(by);
    }

    public void setLANKind(byte by) throws SQLException {
        this.lanHeader.setKind(by);
    }

    public byte getLANKind() {
        return this.lanHeader.getKind();
    }

    public int getRequestNumber() {
        return this.lanHeader.getRequestNo();
    }

    public void setByteVar(byte by) throws SQLException {
        this.lanHeader.setByteVar(by);
    }

    public void setSessionNumber(int n) throws SQLException {
        this.lanHeader.setSessionNo(n);
    }

    public void setRequestNumber(int n) throws SQLException {
        this.lanHeader.setRequestNo(n);
    }

    public void setHostCharSet(byte by) throws SQLException {
        this.lanHeader.setHostCharSet(by);
    }

    public byte getHostCharSet() {
        return this.lanHeader.getHostCharSet();
    }

    public void setAuthentication(long l) throws SQLException {
        this.lanHeader.setAuthentication(l);
    }

    public long getAuthentication() {
        return ByteConverter.getLong(this.lanHeader.getAuthentication(), 0);
    }

    public void clear() {
        this.buffer.clear();
    }

    public boolean getEncryption() {
        return this.lanHeader.getEncryption();
    }

    public void setClassType(byte by) throws SQLException {
        this.lanHeader.setClassType(by);
    }

    public boolean inTransaction() {
        return this.lanHeader.inTransaction();
    }

    public void setControlDataLength(int n) throws SQLException {
        this.lanHeader.setControlDataLength(n);
    }

    public int getControlDataLength() {
        return this.lanHeader.getControlDataLength();
    }
}

