/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class Result {
    public static final boolean EXECUTE_FAILURE = true;
    public static final boolean EXECUTE_SUCCESS = false;
    public static final int UPDATE_COUNT = 1;
    public static final int RS = 2;
    public static final int RS_AND_UPDATE = 3;
    private long m_nLargeUpdateCount;
    private TDResultSet rs;
    private int type;
    private SQLWarning m_largeUpdateSqlWarning;
    private SQLWarning m_smallUpdateSqlWarning;

    public Result(boolean bl, long l, int n) {
        this.m_nLargeUpdateCount = bl ? -3L : this.getModifiedUpdateCount(l, n);
        this.type = 1;
    }

    public Result(TDResultSet tDResultSet) {
        this.rs = tDResultSet;
        this.type = 2;
    }

    public Result(long l, TDResultSet tDResultSet, int n) {
        this.m_nLargeUpdateCount = this.getModifiedUpdateCount(l, n);
        this.rs = tDResultSet;
        this.type = 3;
    }

    private long getModifiedUpdateCount(long l, int n) {
        if (l < 0L) {
            BigInteger bigInteger = new BigInteger(Long.toHexString(l), 16);
            this.m_largeUpdateSqlWarning = ErrorFactory.makeSQLWarning("TJ1601", String.valueOf(n), String.valueOf(bigInteger));
            this.m_smallUpdateSqlWarning = ErrorFactory.makeSQLWarning("TJ781", String.valueOf(n), String.valueOf(bigInteger));
            return Long.MAX_VALUE;
        }
        if (l > Integer.MAX_VALUE) {
            this.m_smallUpdateSqlWarning = ErrorFactory.makeSQLWarning("TJ781", String.valueOf(n), String.valueOf(l));
        }
        return l;
    }

    public SQLWarning getSmallUpdateCountWarning() {
        SQLWarning sQLWarning = this.m_smallUpdateSqlWarning;
        this.m_smallUpdateSqlWarning = null;
        return sQLWarning;
    }

    public SQLWarning getLargeUpdateCountWarning() {
        SQLWarning sQLWarning = this.m_largeUpdateSqlWarning;
        this.m_largeUpdateSqlWarning = null;
        return sQLWarning;
    }

    public int getType() {
        return this.type;
    }

    public int getSmallUpdateCount() throws SQLException {
        long l = this.getLargeUpdateCount();
        return l <= Integer.MAX_VALUE ? (int)l : Integer.MAX_VALUE;
    }

    public long getLargeUpdateCount() throws SQLException {
        if (this.type == 1 || this.type == 3) {
            return this.m_nLargeUpdateCount;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ191");
    }

    public long getBatchIndexLargeUpdateCount() {
        if (this.type == 1 || this.type == 3) {
            return this.m_nLargeUpdateCount;
        }
        return -3L;
    }

    public TDResultSet getResultSet() throws SQLException {
        if (this.type == 2 || this.type == 3) {
            return this.rs;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ192");
    }

    public String toString() {
        return super.toString() + "(" + (this.type == 1 || this.type == 3 ? "updc=" + this.m_nLargeUpdateCount : "") + (this.type == 3 ? " " : "") + (this.type == 2 || this.type == 3 ? "rs=" + String.valueOf(this.rs) : "") + ")";
    }
}

