/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class RawParameterMetaData
implements ParameterMetaData {
    private RawPreparedStatement pstmt = null;
    private int numberOfParameters = 1;

    public RawParameterMetaData(RawPreparedStatement rawPreparedStatement) throws SQLException {
        this.pstmt = rawPreparedStatement;
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > this.numberOfParameters) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "[B";
    }

    @Override
    public int getParameterCount() throws SQLException {
        this.pstmt.abortIfClosed();
        return this.numberOfParameters;
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return -3;
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "VARBYTE";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

