/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.OIDCMetadataCache;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class ClientSecretFlow {
    public static void validateClientSecretFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        if (string != null && string.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1572", uRLParameters.getLogMech());
        }
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1573", uRLParameters.getLogMech());
        }
        if (uRLParameters.getOAuthScopes() != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "OAUTH_SCOPES", uRLParameters.getLogMech());
        }
        if (uRLParameters.getLogData() == null || uRLParameters.getLogData().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1582", "LOGDATA", uRLParameters.getLogMech());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doClientSecretFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, TokenCache.CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doClientSecretFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
            Utility.HttpResponse httpResponse = OIDCMetadataCache.getResponse(genericTeradataConnection, string3);
            String string6 = httpResponse.sBody;
            String string7 = Utility.getStringFromJSON("token_endpoint", string6, "TJ1544", string3);
            String string8 = uRLParameters.getLogData();
            String string9 = string4 + ":" + string8;
            String string10 = Utility.base64Encode(false, Encoder.encodeStringUTF8(string9));
            String string11 = "Authorization: Basic " + string10;
            String string12 = "grant_type=client_credentials&scope=" + Utility.safeForURL(string5);
            if (log.isDebugEnabled()) {
                log.debug("sJSON=" + string6);
                log.debug("sTokenURL=" + string7);
                log.debug("sClientSecret=" + string8);
                log.debug("sCredentials=" + string9);
                log.debug("sCredentialsBase64=" + string10);
                log.debug("sAuthorization=" + string11);
                log.debug("sFormData=" + string12);
            }
            byte[] byArray = Encoder.encodeStringUTF8(string12);
            string6 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string7, (String[])new String[]{string11, "Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
            TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl, string7, string6, cacheContext);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doClientSecretFlow bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }
}

