/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.HttpServer;
import com.teradata.jdbc.jdbc.OIDCMetadataCache;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public class BrowserAuth {
    private static final String PLACEHOLDER = "PLACEHOLDER";

    public static void validateBrowserAuth(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1539");
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1540");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doBrowserAuth(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, boolean bl, TokenCache.CacheContext cacheContext) throws SQLException {
        Log log = genericTeradataConnection.getLog();
        if (log.isDebugEnabled()) {
            log.debug("> enter doBrowserAuth bOAuthFlow=" + bl + " sOIDCScope=" + string5);
        }
        try {
            String string6;
            HttpServer httpServer;
            String string7;
            String string8;
            String string9;
            URLParameters uRLParameters;
            block19: {
                Process process;
                boolean bl2;
                Object object;
                uRLParameters = genericTeradataConnection.getURLParameters();
                String string10 = uRLParameters.getBrowser();
                if (string10 == null || string10.length() == 0) {
                    object = System.getProperty("os.name");
                    String string11 = string9 = object != null ? ((String)object).toUpperCase() : "";
                    if (string9.indexOf("WIN") >= 0) {
                        string10 = "cmd /c start \"title\" \"PLACEHOLDER\"";
                    } else if (string9.indexOf("MAC") >= 0) {
                        string10 = "open PLACEHOLDER";
                    } else {
                        throw ErrorFactory.makeDriverJDBCException("TJ1541", (String)object);
                    }
                }
                object = OIDCMetadataCache.getResponse(genericTeradataConnection, string3);
                string9 = ((Utility.HttpResponse)object).sBody;
                String string12 = Utility.getStringFromJSON("authorization_endpoint", string9, "TJ1544", string3);
                string8 = Utility.getStringFromJSON("token_endpoint", string9, "TJ1544", string3);
                string7 = Utility.base64Encode(true, Utility.getRandomBytes(32));
                String string13 = Utility.base64Encode(true, Utility.hashBytes(log, "SHA-256", Encoder.encodeStringAsciiReplace(genericTeradataConnection, string7)));
                String string14 = "/openid-callback";
                int n = uRLParameters.getBrowserTimeout() * 1000;
                int n2 = uRLParameters.getBrowserTabTimeout() * 1000;
                if (log.isTimingEnabled()) {
                    log.timing("Starting HttpServer with Browser Authentication timeout " + n + " ms and browser tab timeout " + n2 + " ms");
                }
                httpServer = new HttpServer(log, string14 + "?", n, n2);
                string6 = "http://127.0.0.1:" + httpServer.getLocalPort() + string14;
                boolean bl3 = string != null && string.length() > 0;
                boolean bl4 = bl2 = bl3 && uRLParameters.getOIDCPrompt() != null;
                if (log.isDebugEnabled()) {
                    log.debug("sJSON=" + string9);
                    log.debug("sAuthURL=" + string12);
                    log.debug("sTokenURL=" + string8);
                    log.debug("sCodeVerifier=" + string7);
                    log.debug("sCodeChallenge=" + string13);
                    log.debug("sRedirectURL=" + string6);
                    log.debug("sUserName=" + string + " bUseLoginHint=" + bl3);
                    log.debug("getOIDCPrompt=" + uRLParameters.getOIDCPrompt() + " bUsePrompt=" + bl2);
                    log.debug("(before PLACEHOLDER swap) sBrowser=" + string10);
                }
                string10 = string10.replaceAll(PLACEHOLDER, string12 + "?response_type=code" + "&client_id=" + Utility.safeForURL(string4) + "&redirect_uri=" + Utility.safeForURL(string6) + "&code_challenge=" + Utility.safeForURL(string13) + "&code_challenge_method=S256" + "&scope=" + Utility.safeForURL(string5) + (bl3 ? "&login_hint=" + Utility.safeForURL(string) : "") + (bl2 ? "&prompt=" + Utility.safeForURL(uRLParameters.getOIDCPrompt()) : ""));
                if (log.isTimingEnabled()) {
                    log.timing("Launching browser " + string10);
                }
                try {
                    process = Runtime.getRuntime().exec(string10);
                }
                catch (IOException iOException) {
                    throw Utility.logEx(log, "Runtime exec", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1551", string10)));
                }
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block19;
                    log.debug("Ignoring Process stream close exception: " + iOException);
                }
            }
            Map<String, String> map = httpServer.waitForRequestParams(log);
            String string15 = map.get("code");
            if (string15 == null || string15.length() == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ1548");
            }
            String string16 = "grant_type=authorization_code&client_id=" + Utility.safeForURL(string4) + "&code=" + Utility.safeForURL(string15) + "&redirect_uri=" + Utility.safeForURL(string6) + "&code_verifier=" + Utility.safeForURL(string7);
            if (log.isDebugEnabled()) {
                log.debug("sClientID=" + string4);
                log.debug("sCode=" + string15);
                log.debug("sRedirectURL=" + string6);
                log.debug("sCodeVerifier=" + string7);
                log.debug("sFormData=" + string16);
            }
            byte[] byArray = Encoder.encodeStringUTF8(string16);
            string9 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string8, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
            TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, bl, string8, string9, cacheContext);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("< leave doBrowserAuth bOAuthFlow=" + bl + " sOIDCScope=" + string5);
            }
        }
    }
}

